% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.signtest}
\alias{average.power.signtest}
\title{Compute average power of many sign tests}
\usage{
average.power.signtest(n, alpha, p)
}
\arguments{
\item{n}{sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{p}{Pr(Y>X), as in Noether (JASA 1987)}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of many sign tests
}
\examples{
p = rep(c(0.8,0.5),c(100,900));
average.power.signtest(n = 50, alpha = 0.05, p=p)
}
\seealso{
\code{\link{power.signtest}} for more details about power calculation of sign test. The power calculation is based on asymptotic normal approximation.
}
