% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_spec.R
\name{summary.FCVAR_ranks}
\alias{summary.FCVAR_ranks}
\title{Summarize Results of Tests for Cointegrating Rank}
\usage{
\method{summary}{FCVAR_ranks}(object, ...)
}
\arguments{
\item{object}{An S3 object of type \code{FCVAR_ranks} containing the results
from repeated estimation of the FCVAR model with different
cointegrating ranks. It is the output of \code{FCVARrankTests}.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
\code{summary.FCVAR_ranks} prints the table of statistics from
the output of \code{FCVARrankTests}.
\code{FCVARrankTests} performs a sequence of  likelihood ratio tests
	for cointegrating rank.
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
rankTestStats <- FCVARrankTests(x, k = 2, opt)
summary(object = rankTestStats)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} is called repeatedly within this function
for each candidate cointegrating rank.
\code{summary.FCVAR_ranks} prints a summary of the output of \code{FCVARrankTests} to screen.

Other FCVAR specification functions: 
\code{\link{FCVARbootRank}()},
\code{\link{FCVARlagSelect}()},
\code{\link{FCVARrankTests}()},
\code{\link{summary.FCVAR_lags}()}
}
\concept{FCVAR specification functions}
