% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDM.R
\name{compute.EPI}
\alias{compute.EPI}
\title{Estimation of EPI}
\usage{
compute.EPI(coeff, m = 1:10, q = 0.98)
}
\arguments{
\item{coeff}{A list, containing the t x n dimensional principle components/expansion coefficients of TPDM.
Can also be output of function 'est.tpdm'.}

\item{m}{numeric vector: Containing the Principle Components from which EPI shall be computed (e.g. with modes = c(1:10), the EPI is calculated on first ten principle components)}

\item{q}{Optional: A threshold for computation of TEPI}
}
\value{
An array of length t, containing EPI. TEPI is computed if if q > 0.
}
\description{
Estimates the extremal pattern index (EPI) from either the 'm' principle components after a PCA
or left- and right expansion coefficients after an SVD. In case of a SVD,
the threshold-based EPI (TEPI) can optionally be calculated.
}
\details{
Given the first 'm' modes of principle components u and eigenvalues after a PCA, the EPI is given as:
\deqn{EPI_t^{u} = \sqrt{\sum_{k=1}^m (u_{t,k}^2)/\sum_{j=1}^m e_j}.}
Given the first 'm' modes of expansion coefficients u and v and singular values e after a SVD, the EPI and TEPI are given as:
\deqn{EPI_t^{u, v} = \sqrt{\sum_{k=1}^m (u_{t,k}^2 + v_{t,k}^2)/\sum_{j=1}^m e_j}.}
\deqn{TEPI_t^{u, v} = \sqrt{(\sum_{k=1}^m (u_{t,k}^2 + v_{t,k}^2)/\sum_{j=1}^m e_j) |_{(|u_{t,k}| > q_u , |v{t,k}| > q_v)}}.}
}
\examples{
data    <- precipGER
\donttest{
data.alpha2  <- to.alpha.2(data$pr)
Sigma   <- est.tpdm(data.alpha2,anz_cores =1)
res.pca <- pca.tpdm(Sigma, data.alpha2)
EPI <- compute.EPI(res.pca, m = 1:10)

plot(data$date, EPI, type='l')}
}
\references{
Szemkus & Friederichs (2023)
}
