% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_indicators.R
\name{compute_indicators}
\alias{compute_indicators}
\title{Compute diagnostic test indicators}
\usage{
compute_indicators(tp, fp, fn, tn, prev, conf = 0.95)
}
\arguments{
\item{tp}{True positives}

\item{fp}{False positives}

\item{fn}{False negatives}

\item{tn}{True negatives}

\item{prev}{Prevalence (numeric between 0 and 1)}

\item{conf}{Confidence level (default 0.95)}
}
\value{
A list with all diagnostic indicators and confidence intervals
}
\description{
This function computes sensitivity, specificity, predictive values,
likelihood ratios, accuracy, and Youden index with their confidence intervals
(with desired confidence level), based on a 2x2 table of diagnostic test results.
}
\examples{
compute_indicators(58, 15, 14, 26, prev = 0.1, conf = 0.95)
}
