% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_weibull.R
\name{boot_weibull}
\alias{boot_weibull}
\title{Parametric Bootstrap of time-to-event data following a Weibull distribution}
\usage{
boot_weibull(t0, B = 1000, theta, C, N)
}
\arguments{
\item{t0}{time point of interest}

\item{B}{number of bootstrap repetitions. The default is B=1000}

\item{theta}{parameter of the Weibull distribution, theta=(shape,scale)}

\item{C}{rate of the exponential distribution specifiying the censoring}

\item{N}{size of the dataset = number of observations}
}
\value{
A vector of length B containing the estimated survival at t0
}
\description{
Function generating bootstrap data according to a Weibull distribution (specified by a model parameter \eqn{\theta}),
assuming exponentially distributed right-censoring (specified by a rate C). After data generation again a model is fitted and evaluated
at a pre-specified time point \eqn{t_0} yielding the response vector.
}
\examples{
t0<-2
N<-30
C<-1
boot_weibull(t0=t0,theta=c(1,3),C=C,N=N)
}
