% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/present_to_annual.R
\name{present_to_annual}
\alias{present_to_annual}
\title{Compute annual payment from present value

\code{present_to_annual} Compute uniform series annual payments from present value
using capital recovery factor (crf)}
\usage{
present_to_annual(i, n, PV)
}
\arguments{
\item{i}{discount rate in percent per year}

\item{n}{life span in years}

\item{PV}{present value}
}
\value{
ann.value
}
\description{
Compute annual payment from present value

\code{present_to_annual} Compute uniform series annual payments from present value
using capital recovery factor (crf)
}
\examples{
# Result: ann.value = $17765.49
present_to_annual(0.08, 30, 200000)  

}
\references{
Newnan, D. G., Eschenbach, T. G., Lavelle, J. P., & Oxford, N. Y.
Engineering Economic Analysis, 14th ed.
New York, Oxford University Press, 2020

David, W., & Terry, R.
Fundamentals of Engineering Economics and Decision Analysis.
Springer Nature, 2012
}
