% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_prop_test.R
\name{trainer_prop_test}
\alias{trainer_prop_test}
\title{Interpret a proportion test (prop.test) with an audience-aware LLM prompt}
\usage{
trainer_prop_test(
  pt_obj,
  introduction = NULL,
  alpha = 0.05,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{pt_obj}{An htest object returned by stats::prop.test().}

\item{introduction}{Optional character string giving the study context.}

\item{alpha}{Numeric significance level (default 0.05).}

\item{audience}{One of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a 3-bullet executive summary
regardless of audience depth (uses trainer_core_summary_only_block()).}

\item{llm_model}{Character; model name for the generator (default "llama3").}

\item{generate}{Logical; if TRUE, call the generator and return prompt + response.}
}
\value{
If generate = FALSE, a prompt string. If TRUE, a list with
  prompt, response, and model.
}
\description{
Builds a clear, audience-tailored prompt to interpret stats::prop.test() results
(one-sample vs target p, two-sample equality, k-group equality, or k-group vs given p).
Aligned with other TraineR trainers: no invented numbers; audience-specific guidance.
}
\examples{
# One-sample
pt1 <- prop.test(x = 56, n = 100, p = 0.5)
cat(trainer_prop_test(pt1, audience = "beginner"))

# Two-sample
pt2 <- prop.test(x = c(42, 35), n = c(100, 90))
cat(trainer_prop_test(pt2, audience = "applied", summary_only = TRUE))
}
