% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxSprtCriticalValues.R
\name{computeCvPoissonRegression}
\alias{computeCvPoissonRegression}
\title{Compute critical values for Poisson regression data}
\usage{
computeCvPoissonRegression(
  groupSizes,
  z,
  minimumEvents = 1,
  alpha = 0.05,
  sampleSize = 1e+06
)
}
\arguments{
\item{groupSizes}{Vector containing the expected number of events under H0 for each test.}

\item{z}{The control time divided by the time at risk.}

\item{minimumEvents}{The minimum number of events needed before the null hypothesis can be rejected.}

\item{alpha}{The significance level, or the type 1 error probability, which is the probability
of rejecting the null hypothesis when it is true.}

\item{sampleSize}{Sample size for the Monte-Carlo simulations.}
}
\value{
The computed critical value. The 'alpha' attribute of the result indicates the selected alpha.
}
\description{
Obtains critical values for the group and continuous sequential MaxSPRT test with Poisson regression data,
using a Wald type upper boundary, which is flat with respect to the likelihood ratio function,
and with a pre-specified upper limit on the sample size.

It is often not possible to select a critical value that corresponds to the exact alpha specified.
Instead, this function will select the least conservative critical value having an alpha below
the one specified, so the sequential analysis is conservative.
}
\examples{
groupSizes <- rep(1, 10)
computeCvPoissonRegression(groupSizes, z = 4)

}
