% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomeloextract.R
\name{randomeloextract}
\alias{randomeloextract}
\title{extract ratings from random sequences based on an interaction matrix}
\usage{
randomeloextract(x, ID, mode = c("obj", "samp", "avg"))
}
\arguments{
\item{x}{output from \code{\link{randomelo}}}

\item{ID}{character, ID}

\item{mode}{character, one of three: 1) \code{"obj"}: a random value from all
the sequences; 2) \code{"samp"}: a random value sampled from a normal
distribution with mean and sd of all randomized values; 3)
\code{"avg"}: the average value from all the runs}
}
\value{
numeric
}
\description{
extract ratings from random sequences based on an interaction matrix
}
\examples{
data(adv)
elores <- elo.seq(winner = adv$winner, loser = adv$loser, Date = adv$Date)
mat <- creatematrix(elores)
res <- randomelo(mat, runs = 10)
randomeloextract(res, "a", "samp")
randomeloextract(res, "a", "obj")
randomeloextract(res, "a", "avg")
}
\author{
Christof Neumann
}
