% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISIranks.R
\name{ISIranks}
\alias{ISIranks}
\title{ISI ranks}
\usage{
ISIranks(x, sortbyID = TRUE)
}
\arguments{
\item{x}{a list of matrices, with the same column names, typically the output of \code{\link{ISI}}}

\item{sortbyID}{logical, should the output be sorted by ID (default is \code{TRUE}). If \code{FALSE}, output is sorted by (average rank)}
}
\value{
a data.frame with at least three columns: IDs, their average rank and the rankings of all rankings that satisfy ISI's minimum criteria
}
\description{
ISI ranks
}
\details{
if there is more than one solution resulting from \code{\link{ISI}}, average (mean) ranks will be calculated. If there is only one solution, the average rank will be the same as the rank from the (one) ISI ranking
}
\examples{
# no unique solution
data(adv)
mat <- creatematrix(winners = adv$winner, losers = adv$loser)
set.seed(123)
res <- ISI(mat)
ISIranks(res)
ISIranks(res, sortbyID = FALSE)

# only one (and unique) solution
data(bonobos)
set.seed(123)
res <- ISI(bonobos)
ISIranks(res)
ISIranks(res, sortbyID = FALSE)
}
