% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EXRQ.R
\name{ThreeStage}
\alias{ThreeStage}
\title{Three-Stage Extreme Conditional Quantile Estimator}
\usage{
ThreeStage(y, x, xstar, tau.e, grid.lam = seq(-2, 2, 0.1), grid.k, tau.lam,
  a = 0, tol = 1e-04)
}
\arguments{
\item{y}{a vector of n responses}

\item{x}{a n x p matrix of n observations and p predictors}

\item{xstar}{a m x p matrix of m observations and p predictors}

\item{tau.e}{the extreme quantile level of interest}

\item{grid.lam}{the set of lambda (transformation parameter) values for grid search}

\item{grid.k}{the grid for the number of upper order statistics involved in Hill estimator;
used for searching for the data-adaptive k. If the lenfth of grid.k is 1, then k is fixed at grid.k and no selection is performed.}

\item{tau.lam}{the quantile level used for estimating the transformation parameter}

\item{a}{location shift parameter in the power transformation (introduced to avoid negative y values)}

\item{tol}{the tolerance level for checking quantile crossing issue}
}
\value{
A list is returned with the following components

lam: the estimated power-transformation parameter

k: the selected k, the number of upper order statistics involved in Hill estimator

gamma.x: the estimated x-dependent extreme value index (EVI)

cgmma: the pooled EVI estimation

Q3Stage: the three-stage estimator of the tau.e-th conditional quantile of Y given xstar based on the x-dependent EVI estimation

Q3StageP: the three-stage estimator of the tau.e-th conditional quantile of Y given xstar based on the pooled EVI estimation
}
\description{
Provides the estimation of extreme conditional quantile using the three-stage estimation method in Wang and Li (2013). Specifically the function estimates
the tau.e-th conditional quantile of Y given x=xstar based on the power-transformed quantile regression model and extreme value theory. The method is based
on Hill estimator for the extreme value index and works for heavy-tailed distributions (on the original scale).
}
\examples{
#A simulation example (sqrt transformation, heteroscedastic error)
library(EXRQ)
n=500
tau.e = c(0.99, 0.993, 0.995)
set.seed(12368819)
x1 = runif(n, -1, 1)
x2 = runif(n, -1, 1)
sqrty = 2 + x1 + x2 + (1+0.8*x1)*rpareto(n, 0.5)
x = as.matrix(cbind(x1, x2))
y = sqrty^2
xstar = rbind(c(-0.5,0),c(0,-0.5),c(0,0),c(0.5,0),c(0,0.5))
## 3Stage estimator
out.3stage <- ThreeStage(y, x, xstar, tau.e, grid.lam=seq(-0.5, 1.5, 0.1), grid.k=50, tau.lam=0.9)
}
\references{
Wang, H. and Li, D. (2013). Estimation of conditional high quantiles through power transformation. Journal of the American Statistical Association, 108, 1062-1074.
}
\seealso{
\code{\link{TwoStage}}
}

