% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_delta}
\alias{plot_delta}
\title{Plot Difference of Cumulative Distribution Functions}
\usage{
plot_delta(
  input,
  post_predict = NULL,
  prior_predict = NULL,
  subject = NULL,
  quants = c(0.025, 0.975),
  functions = NULL,
  factors = NULL,
  delta_factor = "R",
  n_cores = 1,
  n_post = 50,
  layout = NA,
  to_plot = c("data", "posterior", "prior")[1:2],
  use_lim = c("data", "posterior", "prior")[1:2],
  legendpos = c("topleft"),
  posterior_args = list(),
  prior_args = list(),
  add_percentiles = c(1:9) * 10,
  rev_delta = FALSE,
  ...
)
}
\arguments{
\item{input}{Either an \code{emc} object or a data frame, or a \emph{list} of such objects.}

\item{post_predict}{Optional posterior predictive data (matching columns) or \emph{list} thereof.}

\item{prior_predict}{Optional prior predictive data (matching columns) or \emph{list} thereof.}

\item{subject}{Subset the data to a single subject (by index or name).}

\item{quants}{Numeric vector of credible interval bounds (e.g. \code{c(0.025, 0.975)}).}

\item{functions}{A function (or list of functions) that create new columns in the datasets or predictives}

\item{factors}{Character vector of factor names to aggregate over;
defaults to plotting full data set ungrouped by factors if \code{NULL}.}

\item{delta_factor}{The name of the factor to delta}

\item{n_cores}{Number of CPU cores to use if generating predictives from an \code{emc} object.}

\item{n_post}{Number of posterior draws to simulate if needed for predictives.}

\item{layout}{Numeric vector used in \code{par(mfrow=...)}; use \code{NA} for auto-layout.}

\item{to_plot}{Character vector: any of \code{"data"}, \code{"posterior"}, \code{"prior"}.}

\item{use_lim}{Character vector controlling which source(s) define \code{xlim}.}

\item{legendpos}{Character vector controlling the positions of the legends}

\item{posterior_args}{Optional list of graphical parameters for posterior lines/ribbons.}

\item{prior_args}{Optional list of graphical parameters for prior lines/ribbons.}

\item{add_percentiles}{Vector of integers giving percentiles to plot as points, NULL stops plotting.}

\item{rev_delta}{If FALSE (the default) the first level of the defective
factor is subtracted from the second, if TRUE this is reversed.}

\item{...}{Other graphical parameters for the real data lines.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Plots panels of differences in cumulative distribution functions (CDFs)
between conditions specified by the delta factor in the data.
Optionally, posterior and/or prior predictive delta functions can be overlaid.
}
\examples{
# Plot delta function for data only, not that the delta_factor must have two
# levels.
# fortsmann_speed_accuracy <- forstmann[forstmann$E!="neutral",]
# fortsmann_speed_accuracy$E <- droplevels(fortsmann_speed_accuracy$E)
# plot_delta(fortsmann_speed_accuracy, to_plot = "data")
#
# Plot with posterior predictions
# plot_delta(samples_LNR, to_plot = c("data","posterior"), n_post=10)
#
# Or a list of multiple emc objects ...
}
