% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MM_catal_est.R
\name{MM_catal_est}
\alias{MM_catal_est}
\title{Function for estimating both of the Michaelis-Menten constant and catalytic constant simultaneously}
\usage{
MM_catal_est(
  method,
  timespan,
  products,
  enz,
  subs,
  K_M_init,
  std,
  tun,
  nrepeat,
  jump,
  burn,
  catal_m,
  catal_v,
  K_M_m,
  K_M_v,
  volume,
  t_unit,
  c_unit
)
}
\arguments{
\item{method}{This determines which model, the sQSSA or tQSSA model, is used for the estimation. Specifically, the input for method is TRUE (FALSE); then the tQSSA (sQSSA) model is used.}

\item{timespan}{time points when the concentrations of products were measured.}

\item{products}{measured concentrations of products}

\item{enz}{initial enzyme concentrations}

\item{subs}{initial substrate concentrations}

\item{K_M_init}{initial value of K_M constant for the Metropolis-Hastings algorithm. If the input is FALSE then it is determined by max(subs).}

\item{std}{standard deviation of proposal distribution. If the input is FALSE then it is determined by using the hessian of log posterior distribution.}

\item{tun}{tunning constant for the Metropolis-Hastings algorithm when std is FALSE (i.e., hessian of the log posterior distribution is used).}

\item{nrepeat}{number of effective iteration, i.e., posterior samples.}

\item{jump}{length of distance between sampling, i.e., thinning rate.}

\item{burn}{length of burn-in period.}

\item{catal_m}{prior mean of gamma prior for the catalytic constant k_cat.}

\item{catal_v}{prior variance of gamma prior for the catalytic constant k_cat.}

\item{K_M_m}{prior mean of gamma prior for the Michaelis-Menten constant K_M. If the input is FALSE then it is determined by max(subs).}

\item{K_M_v}{prior variance of gamma prior for the Michaelis-Menten constant K_M. If the input is FALSE then it is determined by max(subs)^2*1000.}

\item{volume}{the volume of a system. It is used to scale the product concentration. FALSE input provides automatic scaling.}

\item{t_unit}{the unit of time points. It can be an arbitrary string.}

\item{c_unit}{the unit of concentrations. It can be an arbitrary string.}
}
\value{
A matrix containing posterior samples of the estimated parameters: the catalytic constant and the Michaelis-Menten constant.
}
\description{
The function estimates both of the catalytic and the Michaelis-Meten constants simultaneously using progress-curve data,
enzyme concentrations, and substrate concentrations.
}
\details{
The function MM_catal_est generates a set of Markov Chain Monte Carlo
simulation samples from the posterior distribution of K_M and catalytic
constant of enzyme kinetics model.
Authors' recommendation: "Do not use this function directly. Do use the function main_est()
to estimate the parameters so that the main function calls this function"
}
\examples{
\dontrun{
data("timeseries_data_example")
timespan1=timeseries_data_example[,c(1,3,5,7)]
products1=timeseries_data_example[,c(2,4,6,8)]
MM_catal_result <- MM_catal_est(method=TRUE,timespan=timespan1,
products=products1,enz = c(4.4, 4.4, 440, 440), subs=c(4.4, 4.4, 4.4, 4.4), 
K_M_init = 1, catal_m=1, catal_v = 1000, K_M_m = 1, K_M_v = 100000, 
std = 10, tun =3.5, nrepeat = 1000, jump = 10, burn = 1000, 
volume = FALSE, t_unit = "sec", c_unit = "mM")
}
}
