% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEdgeProbabilitiesTimePoints.R
\name{calculateEdgeProbabilitiesTimePoints}
\alias{calculateEdgeProbabilitiesTimePoints}
\title{Calculate the edge posterior probabilities for each timepoint.}
\usage{
calculateEdgeProbabilitiesTimePoints(network.samples, cps, numNodes)
}
\arguments{
\item{network.samples}{Collection of network and changepoint samples of the
MCMC simulation, as obtained by \code{\link{EDISON.run}},
\code{\link{runDBN}}.}

\item{cps}{Changepoint vector.}

\item{numNodes}{Number of nodes in the network.}
}
\value{
A list of length equal to the number of timepoints, where each entry
contains a matrix of size NumNodes by NumNodes with the marginal posterior
edge probabilities of the network at this timepoint.
}
\description{
This function calculates the marginal posterior edge probabilities of the
network at each timepoint.
}
\author{
Frank Dondelinger
}
\seealso{
\code{\link{calculateEdgeProbabilities}},

\code{\link{calculateEdgeProbabilitiesSegs}}
}

