\name{CZZZ}
\alias{CZZZ}
\title{High-Dimensional Two-Sample Mean Test}
\description{
  Conducts a high-dimensional two-sample mean test with optional variable filtering.
  This function performs both non-studentized and studentized tests to determine
  whether the means of two groups are significantly different.
}
\usage{
CZZZ(X, Y, m = 2500, filter = TRUE, alpha = 0.05)
}
\arguments{
  \item{X}{
    Matrix representing the first group of data (variables in rows, observations in columns).
  }
  \item{Y}{
    Matrix representing the second group of data (variables in rows, observations in columns).
  }
  \item{m}{
    Number of bootstrap samples used for the test (default is 2500).
  }
  \item{filter}{
    Logical parameter indicating whether to filter variables based on mean differences (default is TRUE).
  }
  \item{alpha}{
    Significance level for the test (default is 0.05).
  }
}
\value{
  A list containing the results of the non-studentized and studentized tests.
  Each result includes:
  \item{statistics}{The test statistic.}
  \item{p.value}{The p-value of the test.}
  \item{alternative}{The alternative hypothesis (two-sided).}
  \item{method}{The method description.}
}
\details{
  This function performs a high-dimensional two-sample mean test, which is useful when the number of variables (p) is much larger than the number of observations (n).
  The function includes an optional filtering step to reduce the number of variables based on the difference in means between the two groups.
}
\examples{
# Example usage:
library(MASS)
set.seed(123)
X <- matrix(rnorm(1000), nrow = 100, ncol = 10)  # 100 variables, 10 observations
Y <- matrix(rnorm(1000, mean = 0.5), nrow = 100, ncol = 10)  # Different mean
result <- CZZZ(X, Y, m = 1000, filter = TRUE, alpha = 0.05)
print(result)
}
