\name{inversionTests}
\alias{inversionTestpq}
\alias{inversionTestqp}
\title{
Inversion Tests for Distributions
}
\description{

Functions to check performance of distribution and quantile
functions. Applying the distribution function followed by the quantile
function to a set of numbers should reproduce the original set of
numbers. Likewise applying the quantile function followed by the
distribution function to numbers in the range (0,1) should produce the
original numbers.
}
\usage{
inversionTestpq(densFn = "norm", n = 10,
                intTol = .Machine$double.eps^0.25,
                uniTol = intTol, x = NULL, method = "spline", ...)
inversionTestqp(densFn = "norm",
                qs = c(0.001, 0.01, 0.025, 0.05, 0.1, 0.2, 0.4, 0.5,
                       0.6, 0.8, 0.9, 0.95, 0.975, 0.99, 0.999),
                uniTol = .Machine$double.eps^0.25,
                intTol = uniTol, method = "spline", ...)
}

\arguments{
  \item{densFn}{Character. The root name of the distribution to be tested.}
  \item{qs}{Numeric. Set of quantiles to which quantile function then
  distribution function will be applied. See \bold{Details}.}
  \item{n}{Numeric. Number of values to be sampled from the
    distribution. See \bold{Details}.}
  \item{x}{Numeric. Values at which the distribution function is to be
    evaluated. If \code{NULL} values are drawn at random from the
    distribution.}
  \item{intTol}{Value of \code{rel.tol} and hence \code{abs.tol} in calls
    to \code{integrate}. See \code{\link{integrate}}.}
  \item{uniTol}{Value of \code{tol} in calls to \code{uniroot}. See
    \code{\link{uniroot}}.}
  \item{method}{Character. If \code{"spline"} quantiles are found from a
    spline approximation to the distribution function. If
    \code{"integrate"}, the distribution function used is always obtained
    by integration.}
  \item{\dots}{Additional arguments to allow specification of the
  parameters of the distribution.}
}
\details{
  \code{inversionTestpq} takes a sample from the specified distribution
  of size \eqn{n}{n} then applies the distribution function, followed by
  the quantile function.
  \code{inversionTestqp} applies the quantile function, followed by
  the distribution function to the set of quantiles specified by
  \code{qs}.

  In both cases the starting and ending values should be the same.

  These tests are used in base R to check the standard distribution
  functions. The code may be found in the file \code{d-p-q-r.tests.R} in
  the \code{tests} directory.
}
\value{
  \code{inversionTestpq} returns a list with components:

  \item{qpx}{Numeric. The result of applying the distribution function
    (\file{p} function) then the quantile function (\file{q} function) to
    the randomly generated set of \eqn{x} values.}
  \item{x}{Numeric. The set of \eqn{x} values generated by the \file{r}
    function.}
  \item{diffs}{Numeric. The differences \code{qpx} minus \code{x}.}
  \item{n}{Numeric. Number of values sampled from the distribution.}

  \code{inversionTestqp} returns a list with components:

  \item{pqqs}{Numeric. The result of applying the quantile function
    (\file{q} function) then the distribution function (\file{p} function) to
    the quantiles \code{qs}.}
  \item{qs}{Numeric. The set of quantiles.}
  \item{diffs}{Numeric. The differences \code{pqqs} minus \code{qs}.}
}

\author{
  David Scott \email{d.scott@auckland.ac.nz},
  Christine Yang Dong \email{c.dong@auckland.ac.nz}
}

\examples{
## Default distribution is normal
inversionTestpq()
inversionTestqp()
## Supply parameters
inversionTestpq(mean = 1, sd = 2)
inversionTestqp(mean = 1, sd = 2)
## Gamma distribution, must specify shape
inversionTestpq("gamma", shape = 1)
inversionTestqp("gamma", shape = 1)
}

\keyword{distribution}
\keyword{univariate}
