% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_p0.R
\name{calculate_p0}
\alias{calculate_p0}
\title{Function to calculate the p0 vector used in Random Walk with Restart
(RwR)}
\usage{
calculate_p0(nodes, disease)
}
\arguments{
\item{nodes}{The \code{nodes} variable can either accept the igraph object or the
nodes vector.}

\item{disease}{The \code{disease} variable must specify the disease-affected
nodes in a short vector.}
}
\value{
The resulting p0 vector.
}
\description{
The function provides a reliable approach to generating a p0
vector.
}
\examples{
library(DTSEA)
library(dplyr)

# Load the data
data("example_disease_list", package = "DTSEA")
data("example_drug_target_list", package = "DTSEA")
data("example_ppi", package = "DTSEA")

# Compute the p0 vector
p0 <- calculate_p0(nodes = example_ppi, disease = example_disease_list)

# You can decrease the order of the p0 to get the most affected nodes.
p0 <- sort(p0, decreasing = TRUE) \%>\%
  names() \%>\%
  head(10)

# If you have obtained the supplemental data, then you can compute the p0
# in the real data set

# supp_data <- get_data(c("graph", "disease_related"))
# p0 <- calculate_p0(nodes = supp_data[["graph"]],
#                    disease = supp_data[["disease_related"]])

}
