\name{DRclass-package}

\alias{DRclass-package}

\title{Consider Ambiguity in Probabilistic Descriptions Using Density Ratio Classes}

\description{
Consider ambiguity in probabilistic descriptions by replacing a parametric probabilistic description of uncertainty by a non-parametric set of probability distributions in the form of a Density Ratio Class. This is of particular interest in Bayesian inference.

The Density Ratio Class is particularly suited for this purpose as it is invariant under Bayesian inference, marginalization, and propagation through a deterministic model. Here, invariant means that the result of the operation applied to a Density Ratio Class is again a Density Ratio Class. In particular the invariance under Bayesian inference thus enables iterative learning within the same framework of Density Ratio Classes.

The replacement of exact priors by Density Ratio Classes makes it possible to determine the sensitivity of the posterior to the shape of the prior. 
This is an important extension of the investigation to the width of the prior.

The use of imprecise probabilities in general, and Density Ratio Classes in particular, lead to intervals of characteristics of probability distributions, such as cumulative distribution functions, quantiles, and means.

The package is based on a sample of distribution proportional to the upper bound of the class. Typically this will be sample from the posterior in Bayesian inference. Based on such a sample, the package provides functions to calculate\cr
- lower and upper class boundaries (\code{\link{DRclass_k_Pdf}}, \code{\link{DRclass_lu_Pdf}}),\cr
- lower and upper bounds of cumulative distribution functions (\code{\link{DRclass_k_Cdf}}, \code{\link{DRclass_lu_Cdf}}),\cr
- lower and upper bounds of quantiles (\code{\link{DRclass_k_Quantile}}, \code{\link{DRclass_lu_Quantile}}), and\cr
for the marginals of the Density Ratio Class.\cr

This sensitivity analysis to the shape of the distribution is obtained computationally very cheaply even for the results of Bayesian inference.
If the bounding functions of the prior class are proportional, this does not require any additional evaluation of the bounding functions, l and u, once a sample of the posterior of the distribution proportional to the upper bounding function is available (functions \code{\link{DRclass_k_Pdf}}, \code{\link{DRclass_k_Cdf}}, \code{\link{DRclass_k_Quantile}}).
In the case of different shapes, the bounding functions have to be evaluated at the sample points (functions \code{\link{DRclass_lu_Pdf}}, \code{\link{DRclass_lu_Cdf}}, \code{\link{DRclass_lu_Quantile}}).
However, as only the ratio of bounding functions, l and u, is needed, in the context of Bayesian inference, the bounding functions of the prior can be provided as the likelihood, L, cancels when calculating the ratio: (l L)/(u L) = l/u.
As in most cases the evaluation of the prior is computationally much cheaper than that of the likelihood, the computational effort for the sensitivity analysis is much smaller than the effort of the preceding sampling from the posterior in Bayesian inference..

The package contains a copy of the bisection algorithm from package cmna (\href{https://cran.r-project.org/package=cmna}{https://cran.r-project.org/package=cmna}) modified to allow for additional arguments to the function of which the root is to be found.}

\references{
Direct references underlying this package:

Rinderknecht, S.L., Albert, C., Borsuk, M.E., Schuwirth, N., Kuensch, H.R. and Reichert, P. The effect of ambiguous prior knowledge on Bayesian model parameter inference and prediction. Environmental Modelling & Software. 62, 300-315, 2014. https://doi.org/10.1016/j.envsoft.2014.08.020.

Sriwastava, A. and Reichert, P. Robust Bayesian Estimation of Value Function Parameters using Imprecise Priors. Submitted. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4973574. 

Original references to the Density Ratio Class:

DeRobertis, L., Hartigan, J.A. Bayesian inference using intervals of measures. Ann. Stat. 9 (2), 235-244, 1981.

Berger, J.O. Robust Bayesian analysis: sensitivity to the prior. J. Stat. Plan. Inference 25, 303-328, 1990.

Wasserman, L. Invariance properties of density ratio priors. Ann. Stat. 20 (4), 2177-2182, 1992.

Wasserman, L. and Kadane, J. B. Computing bounds of expectations. Journal of the Americal Statistical Association, 87(418), 483–503, 1992.

Berger, J.O. An overview of robust Bayesian analysis. Test 3, 5-124, 1994.

Geweke, J. and Petrella, L. Prior density-ratio class robustness in econometrics. Journal of Business & Economic Statistics, 16(4), 469–478, 1998.
}
