% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{doypa}
\alias{doypa}
\title{DOYPAColors Palette Selector}
\usage{
doypa(
  palette = NULL,
  n = NULL,
  reverse = FALSE,
  gradient = FALSE,
  type = "all",
  colorblind = FALSE
)
}
\arguments{
\item{palette}{A character string specifying the name of the palette to use. If `NULL`, a random palette will be selected.}

\item{n}{An integer specifying the number of colors to return. If `NULL`, the full palette is returned.}

\item{reverse}{A logical value indicating whether to reverse the order of colors in the palette. Default is `FALSE`.}

\item{gradient}{A logical value indicating whether to interpolate colors as a  gradient of `n` colors between the first and last colors of the palette. If `FALSE`, returns the first `n` colors of the palette.}

\item{type}{A character string specifying the type of palettes to select from: "all", "seq" (sequential), "div" (diverging), or "qual" (qualitative). Default is "all".}

\item{colorblind}{A logical value indicating whether to restrict the palette to colorblind-friendly options. Default is `FALSE`.}
}
\value{
A character vector of colors.
}
\description{
This function provides access to the DOYPAColors palettes, which are categorized into sequential, diverging, and qualitative types. 
You can select a palette, define the number of colors, reverse the order, and interpolate colors as a gradient.
}
\examples{
# Get a palette by name
colors <- doypa("buzz")
print(colors)

# Get a random palette
colors <- doypa()
print(colors)

# Get a palette with a specific number of colors
colors <- doypa("google", n = 3)
print(colors)

# Reverse the order of the palette
colors <- doypa("buzz", reverse = TRUE)
print(colors)

# Interpolate colors as a gradient
colors <- doypa("buzz", n = 10, gradient = TRUE)
print(colors)

}
\seealso{
'list_doypa_pals' to list available palettes.
'preview_doypa_pals' to preview all color palettes.
}
