% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ships_methods.R
\name{set.ship.type}
\alias{set.ship.type}
\title{Convert AIS vessel type identifiers into the ship types recognized by DEPONS}
\usage{
set.ship.type(data, list.ur = FALSE)
}
\arguments{
\item{data}{A \code{DeponsShips} object}

\item{list.ur}{If true, will print a message when a ship type identifier is not recognized and set to the catch-all of "Other".
Defaults to FALSE.}
}
\value{
A \code{DeponsShips} object with ship types that are recognized by DEPONS
}
\description{
Processes a \code{DeponsShips} object to convert numerical (and some written-out) AIS vessel type identifiers
into the types recognized by DEPONS, if the correct types have not already been provided when generating the object (see \code{\link{ais.to.DeponsShips}}).
Type assignment follows MacGillivray & de Jong (2021) and is augmented in some cases by the ship's length and calculated speed.
}
\details{
The safe way to identify ship type is by numeric AIS code - all numbers are handled. Not all of the written-out type names and none
of the detailed type names (Standby Safety, Fire Ship, etc.) are recognized, and these instances will be recoded to "Other". Note
that ships in the "Other" category are also considered as candidates for the assignment of active pauses using \code{\link{make.stationary.ships}}
(e.g., crew transfer vessels and offshore supply ships), thus it is recommended to avoid overloading the category with random vessels.
}
\section{Reference}{

MacGillivray, A., & de Jong, C (2021). A reference spectrum model for estimating
source levels of marine shipping based on Automated Identification System data.
Journal of Marince Science and Engineering, 9(4), 369. doi:10.3390/jmse9040369
}

\examples{
data(shipdata)
shipdata@ships$type <- c(60,99,"Cruise",60,55,"Dredger",60,33,33,31,60,60,60,60,"Cruise")
ships(shipdata)
shipdata <- set.ship.type(shipdata)
ships(shipdata)
}
