% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlgoParamsDEMAP.R
\name{AlgoParamsDEMAP}
\alias{AlgoParamsDEMAP}
\title{AlgoParamsDEMAP}
\usage{
AlgoParamsDEMAP(
  n_params,
  n_chains = NULL,
  n_iter = 1000,
  init_sd = 0.01,
  init_center = 0,
  n_cores_use = 1,
  step_size = NULL,
  jitter_size = 1e-06,
  crossover_rate = 1,
  parallel_type = "none",
  return_trace = FALSE,
  thin = 1
)
}
\arguments{
\item{n_params}{number of free parameters estimated}

\item{n_chains}{number of particle chains, 3*n_params is the default value}

\item{n_iter}{number of iterations to run the sampling algorithm, 1000 is default}

\item{init_sd}{positive scalar or n_params-dimensional numeric vector, determines the standard deviation of the Gaussian initialization distribution}

\item{init_center}{scalar or n_params-dimensional numeric vector that determines the mean of the Gaussian initialization distribution}

\item{n_cores_use}{number of cores used when using parallelization.}

\item{step_size}{positive scalar, jump size in DE crossover step, default is 2.38/sqrt(2*n_params).}

\item{jitter_size}{positive scalar, noise is added during crossover step from Uniform(-jitter_size,jitter_size) distribution. 1e-6 is the default value.}

\item{crossover_rate}{number on the interval (0,1]. Determines the probability a parameter on a chain is updated on a given crossover step, sampled from a Bernoulli distribution.}

\item{parallel_type}{string specifying parallelization type. 'none','FORK', or 'PSOCK' are valid values. 'none' is default value.}

\item{return_trace}{logical, if true, function returns particle trajectories. This is helpful for diagnosing convergence or debugging model code. Function will return an iteration/thin $x$ n_chains $x$ n_params array and the estimated ELBO of each particle in a iteration/thin x n_chains array.}

\item{thin}{positive integer, only every 'thin'-th iteration will be stored. Default value is 1. Increasing thin will reduce the memory required, while running chains for longer.}
}
\value{
list of control parameters for the DEMAP function
}
\description{
get control parameters for DEMAP function
}
