\name{print.DDPstar}
\alias{print.DDPstar}
\title{
Print method for DDPstar objects
}
\description{
Default print method for objects fitted with function \code{DDPstar()}.
}
\usage{
\method{print}{DDPstar}(x, ...)
}
\arguments{
  \item{x}{An object of class \code{DDPstar} as produced by \code{DDPstar()}.}
  \item{\dots}{Further arguments passed to or from other methods. Not yet implemented.}
}
\details{
A short summary is printed.
}
\value{No return value, called for side effects}
\seealso{
\code{\link{DDPstar}}
}
\examples{
library(DDPstar)
data(dde)
dde$GAD <- dde$GAD/7 # GAD in weeks
\donttest{
set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
  data = dde, mcmc = list(nburn = 20000, nsave = 15000, nskip = 1), 
  prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
  standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE, compute.DIC = TRUE)
fit_dde
}
\dontshow{
mcmc <- list(nburn = 20, nsave = 15, nskip = 1)

set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
data = dde, mcmc = mcmc, prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)
fit_dde
}
}