\name{mcmccontrol}
\alias{mcmccontrol}
\title{
Markov chain Monte Carlo (MCMC) parameters
}
\description{
This function is used to set various parameters controlling the Markov chain Monte Carlo (MCMC) parameters.
}
\usage{
mcmccontrol(nsave = 8000, nburn = 2000, nskip = 1)
}
\arguments{
  \item{nsave}{An integer giving the total number of scans to be saved (does not include the burn-in and thinning iterations). }
  \item{nburn}{An integer giving the number of burn-in scans.}
  \item{nskip}{An integer giving the thinning interval,}
}
\details{
The value returned by this function is used as a control argument of the \code{\link{DDPstar}} function.
}
\value{
A list with components for each of the possible arguments.
}
\seealso{
\code{\link{DDPstar}}
}
\examples{
library(DDPstar)
data(dde)
dde$GAD <- dde$GAD/7 # GAD in weeks
\donttest{
mcmc <- mcmccontrol(nburn = 20000, nsave = 15000, nskip = 1)

set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
  data = dde, mcmc = mcmc, prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
  standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE, compute.DIC = TRUE)
summary(fit_dde)
}
\dontshow{
mcmc <- mcmccontrol(nburn = 20, nsave = 15, nskip = 1)

set.seed(10) # For reproducibility
fit_dde <- DDPstar(formula = GAD ~ f(DDE, bdeg = 3, nseg = 20, pord = 2, atau = 1, btau = 0.005), 
data = dde, mcmc = mcmc, prior = list(a = 2, b = 0.5, aalpha = 2, balpha = 2, L = 20), 
standardise = TRUE, compute.lpml = TRUE, compute.WAIC = TRUE)
summary(fit_dde)
}
}