\name{DALY-package}
\alias{DALY-package}
\alias{DALY}

\docType{package}

\title{The DALY Calculator -- Graphical User Interface for Probabilistic DALY Calculation in R}

\description{
  The \emph{DALY Calculator} is a free, open-source Graphical User Interface (GUI)
  for probabilistic disability-adjusted life year (DALY) calculation,
  developed in the \R environment for statistical computing.
  \cr\cr
  The main goal of the \emph{DALY Calculator} is to provide a flexible and
  easy-to-use tool for DALY calculation, and to promote consistency in the
  uncertainty analysis of DALYs.
}

\details{
  \tabular{ll}{
    Package: \tab DALY\cr
    Type: \tab Package\cr
    Version: \tab 1.5.0\cr
    Date: \tab 2016-11-25\cr
    Depends: \tab R (>= 3.3.0)\cr
    License: \tab GPL (>= 2)\cr
    SystemRequirements: \tab Tcl/Tk (>= 8.5), Tktable (>= 2.9)\cr
    URL: \tab \url{http://daly.cbra.be}\cr
  }
}

\author{
  Brecht Devleesschauwer,
  Scott McDonald,
  Juanita Haagsma,
  Nicolas Praet,
  Arie Havelaar,
  Niko Speybroeck
  
  \strong{Maintainer:} \email{brechtdv@gmail.com}
}

\references{
  \itemize{
    \item{\url{http://daly.cbra.be}}
    \item{Devleesschauwer B, et al. (2014). Calculating Disability-Adjusted
          Life Years to quantify burden of disease. \emph{International Journal
          of Public Health 59,} 565-569. \url{http://dx.doi.org/10.1007/s00038-014-0552-z}}
    \item{Murray CJL (1994). Quantifying the burden of disease: the technical basis
	      for disability-adjusted life years. \emph{Bulletin of the World Health
		  Organization 72,} 429-445.}
    \item{Praet N, et al. (2009). The disease burden of \emph{Taenia solium}
          cysticercosis in Cameroon. \emph{PLoS Neglected Tropical Diseases
          3,} e406.}
    \item{Kortbeek LM, et al. (2009). Congenital toxoplasmosis and DALYs in
          the Netherlands. \emph{Memorias de Instituto Oswaldo Cruz 104,}
          370-373.}
  }
}

\seealso{
  \code{\link{DALYcalculator}}
  (for a brief description of the \emph{DALY Calculator})\cr
  \code{\link{DALYmanual}}
  (for a more comprehensive overview)
}
