% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality_factor.R
\name{centrality_factor}
\alias{centrality_factor}
\title{Calculate centrality}
\usage{
centrality_factor(node_list, edge_list)
}
\arguments{
\item{node_list}{Dataframe with an 'id' column for each node and a
'term' column specifying which term the course is to be taken in.}

\item{edge_list}{Dataframe with two columns 'from' and 'to' specifying
directed edges starting at 'from' nodes directed towards 'to' nodes. Entries
must use node ids from \code{node_list}.}
}
\value{
A dataframe containing the centrality of each node
}
\description{
A helper function for calculating the centrality for each node.
}
\details{
A course is considered central if it has many requisite edges flowing in and
out of the node. More formally it is the number of long paths that include the
node. That is, consider a curriculum graph \eqn{G_c} and a vertex \eqn{v_i}. A
long path is a path that satisfies the following conditions:
\itemize{
\item \eqn{v_i,v_j,v_k} are distinct
\item \eqn{v_j \to v_i \to v_k}
\item \eqn{v_j} is a source node (in-degree zero)
\item \eqn{v_k} is a sink node (out-degree zero)
}

Let \eqn{P_{v_i}=\{p_1,p_2,\dots\}} denote the set of all paths defined as
above. Then the centrality of a node \eqn{v_i} is given by
\deqn{q(v_i)=\sum^{|P_{v_i}|}_{l=1}\#(p_l)}
More plainly this is the number of paths containing \eqn{v_i} of at least length 3 where \eqn{v_i} is neither a source nor sink node.
}
\examples{
edge_list <- data.frame(from = c(1, 3), to = c(3, 4))
node_list <-
data.frame(
 id = 1:4,
 label = c("MATH 100", "DATA 101", "MATH 101", "MATH 221"),
 term = c(1, 1, 2, 2)
)

cf_df <- centrality_factor(node_list,edge_list)
print(cf_df)
# Output:
#   id cf
#1  1  0
#2  2  0
#3  3  3
#4  4  0
}
\references{
Heileman, Gregory L, Chaouki T Abdallah, Ahmad Slim, and Michael
Hickman. 2018. “Curricular Analytics: A Framework for Quantifying the Impact
of Curricular Reforms and Pedagogical Innovations.” arXiv Preprint
arXiv:1811.09676.
}
\author{
Daniel Krasnov
}
