#setwd('P:/paper/RobustLrt/simu/review1');
#source('CoxLikelihood.txt');


CoxLikelihood = function(time, event, X, robust = TRUE, weights = NULL, alpha = 0.05) {
RobustCoxLrt = function(X1, alpha = 0.025, robust = TRUE, weights = NULL, hr0 = 1) {
	var1 = X1[, -(1:3)];
	trt = X1$trt;
	if (is.null(weights)) weights = rep(1, length(trt))
	if (ncol(X1) > 3) fit1 = coxph(Surv(X1$time, X1$event) ~ trt + var1, robust = TRUE, weights = weights)
	else fit1 = coxph(Surv(X1$time, X1$event) ~ trt, robust = TRUE, weights = weights)
	summ_fit1 = summary(fit1);
	coef1 = summ_fit1$coefficients;
	cscale = coef1['trt', 'robust se'] / coef1['trt', 'se(coef)'];

	LrtPvalue = function(beta0) {
		trt1 = beta0 * trt;
		if (ncol(X1) > 3) fit2 = coxph(Surv(X1$time, X1$event) ~ offset(trt1) + var1, robust = TRUE, weights = weights)
		else fit2 = coxph(Surv(X1$time, X1$event) ~ offset(trt1), robust = TRUE, weights = weights)
		tp_idx = length(fit2$loglik);
		z_lrt = sign(coef1['trt', 'coef'] - beta0) * sqrt(2 * (fit1$loglik[2] - fit2$loglik[tp_idx]));
		pval_lrt = pnorm(z_lrt);
		return(pval_lrt);
	}

	RobustLrtPvalue = function(beta0) {
		trt1 = beta0 * trt;
		if (ncol(X1) > 3) fit2 = coxph(Surv(X1$time, X1$event) ~ offset(trt1) + var1, robust = TRUE, weights = weights)
		else fit2 = coxph(Surv(X1$time, X1$event) ~ offset(trt1), robust = TRUE, weights = weights)
		tp_idx = length(fit2$loglik);
		z_lrt = sign(coef1['trt', 'coef'] - beta0) * sqrt(2 * (fit1$loglik[2] - fit2$loglik[tp_idx]));
		pval_lrt = pnorm(z_lrt / cscale);
		return(pval_lrt);
	}

	max_uci = 20;
	LrtCi = function(alpha1) {
		pvalFun = function(beta0) {
			return(LrtPvalue(beta0) - alpha1);
		}
		fit_root = uniroot(pvalFun, lower = -max_uci, upper = max_uci, tol = 1e-8, extendInt = 'downX', trace = 1);
		return(fit_root$root);
	}

	RobustLrtCi = function(alpha1) {
		pvalFun = function(beta0) {
			return(RobustLrtPvalue(beta0) - alpha1);
		}
		fit_root = uniroot(pvalFun, lower = -max_uci, upper = max_uci, tol = 1e-8, extendInt = 'downX', trace = 1);
		return(fit_root$root);
	}

	result = list();
	result$coef = coef1['trt', 'coef'];
	if (robust) {
		result$rlrt_pval = RobustLrtPvalue(log(hr0));
		p_min = RobustLrtPvalue(max_uci);
		p_max = RobustLrtPvalue(-max_uci)
		if (p_min > 1 - alpha) result$rlrt_ci = max_uci
		else if (p_max < 1 - alpha) result$rlrt_ci = -max_uci
		else result$rlrt_ci = RobustLrtCi(1 - alpha)
	}
	else {
		result$lrt_pval = LrtPvalue(0);
		p_min = RobustLrtPvalue(max_uci);
		p_max = RobustLrtPvalue(-max_uci)
		if (p_min > 1 - alpha) result$lrt_ci = max_uci
		else if (p_max < 1 - alpha) result$lrt_ci = -max_uci
		else result$lrt_ci = LrtCi(1 - alpha)
	}
	result$rwald_ci = coef1['trt', 'coef'] + qnorm(alpha) * coef1['trt', 'robust se'];
	result$wald_ci = coef1['trt', 'coef'] + qnorm(alpha) * coef1['trt', 'se(coef)'];
	result = data.frame(result);
	return(result);
}

#print(RobustCoxLrt(X1, 0.025, weights = x1wts, robust = FALSE));
#print(RobustCoxLrt(X1, 0.975, weights = x1wts, robust = FALSE));


#The code for the main function starts here.
	X = data.frame(X);
	pVar = dim(X)[2];
	nSubj = dim(X)[1];
	Xnames = names(X);
	if (is.null(weights)) weights = rep(10, nSubj)
	stopifnot(length(time) == nSubj | length(event) == nSubj | length(weights) == nSubj);
	result = data.frame(matrix(NA, pVar, 4));
	names(result) = c('exp_coef', 'p_value', 'lower_ci', 'upper_ci');
	for (i in 1:pVar) {
		X2 = cbind(time, event, X[, i], X[, -i]);
		X2 = data.frame(X2);
		names(X2)[1:3] = c('time', 'event', 'trt');
		lower = RobustCoxLrt(X2, alpha = alpha / 2, robust = robust, weights = weights);
		upper = RobustCoxLrt(X2, alpha = 1 - alpha / 2, robust = robust, weights = weights);
		result$exp_coef[i] = exp(lower$coef);
		if (robust) {
			result$p_value[i] = lower$rlrt_pval;
			result$lower_ci[i] = exp(lower$rlrt_ci);
			result$upper_ci[i] = exp(upper$rlrt_ci);
		}
		else {
			result$p_value[i] = lower$lrt_pval;
			result$lower_ci[i] = exp(lower$lrt_ci);
			result$upper_ci[i] = exp(upper$lrt_ci);
		}
		if (result$p_value[i] < 0.5) result$p_value[i] = 2 * result$p_value[i]
		else result$p_value[i] = 2 * (1 - result$p_value[i]);
	}
	result = cbind(Xnames, result);
	names(result)[1] = 'variable';
	return(result);
}

