% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{area_between}
\alias{area_between}
\title{Area Between Estimated Autocovariance Functions.}
\usage{
area_between(est1, est2, lags = c(), plot = FALSE)
}
\arguments{
\item{est1}{A numeric vector representing the first estimated autocovariance function.}

\item{est2}{A numeric vector of the same length as \code{est1} representing the second estimated autocovariance function}

\item{lags}{An optional vector of lags starting from 0 up until some other lag. If empty, a vector of lags is created starting from 0 until \code{len(est1) - 1}, by 1.}

\item{plot}{A boolean determining whether a plot should be created. By default, no plot is created.}
}
\value{
A numeric value representing the estimated area between two estimated autocovariance functions.
}
\description{
This function estimates the area between two estimated autocovariance functions.
}
\details{
This function estimates the area between two estimated autocovariance functions over a set of lags, from 0 up to \eqn{h_{n}} defined by
\deqn{
\int_{0}^{h_{n}} \left| \hat{C}_{1}(h) - \hat{C}_{2}(h) \right| dh ,
}
where \eqn{\hat{C}_{1}(\cdot)} and \eqn{\hat{C}_{2}(\cdot)} are estimated autocovariance functions.

To approximate this integral the trapezoidal rule is used.

If \code{lags} is empty, a uniform time grid with a step of 1 will be used which may result in a different area than if lags is specified.
}
\examples{
x <- seq(0, 5, by=0.1)
estCov1 <- exp(-x^2)
estCov2 <- exp(-x^2.1)
area_between(estCov1, estCov2, lags=x)
area_between(estCov1, estCov2, lags=x, plot = TRUE)
}
