% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectednessApproach.R
\name{ConnectednessApproach}
\alias{ConnectednessApproach}
\title{Connectedness Approach}
\usage{
ConnectednessApproach(
  x,
  nlag = 1,
  nfore = 10,
  window.size = NULL,
  corrected = FALSE,
  model = c("VAR", "QVAR", "LAD", "LASSO", "Ridge", "Elastic", "TVP-VAR", "DCC-GARCH"),
  connectedness = c("Time", "Frequency", "Joint", "Extended Joint", "R2"),
  VAR_config = list(QVAR = list(tau = 0.5, method = "fn"), ElasticNet = list(nfolds = 10,
    alpha = NULL, loss = "mae", n_alpha = 10), TVPVAR = list(kappa1 = 0.99, kappa2 =
    0.99, prior = "BayesPrior", gamma = 0.01)),
  DCC_config = list(standardize = FALSE),
  Connectedness_config = list(TimeConnectedness = list(generalized = TRUE),
    FrequencyConnectedness = list(partition = c(pi, pi/2, 0), generalized = TRUE,
    scenario = "ABS"), R2Connectedness = list(method = "pearson", decomposition = TRUE,
    relative = FALSE))
)
}
\arguments{
\item{x}{zoo data matrix}

\item{nlag}{Lag length}

\item{nfore}{H-step ahead forecast horizon}

\item{window.size}{Rolling-window size or Bayes Prior sample size}

\item{corrected}{Boolean value whether corrected or standard TCI should be computed}

\item{model}{Estimation model}

\item{connectedness}{Type of connectedness approach}

\item{VAR_config}{Config for VAR model}

\item{DCC_config}{Config for DCC-GARCH model}

\item{Connectedness_config}{Config for connectedness approach}
}
\value{
Get connectedness measures
}
\description{
This function provides a modular framework combining various models and connectedness frameworks.
}
\examples{
\donttest{
data("acg2020")
dca = ConnectednessApproach(acg2020, 
                            nlag=1, 
                            nfore=12,
                            model="VAR",
                            connectedness="Time",
                            VAR_config=list(TVPVAR=list(kappa1=0.99, kappa2=0.96,
                                            prior="MinnesotaPrior", gamma=0.1)))
dca$TABLE
}
}
\references{
Adekoya, O. B., Akinseye, A. B., Antonakakis, N., Chatziantoniou, I., Gabauer, D., & Oliyide, J. (2022). Crude oil and Islamic sectoral stocks: Asymmetric TVP-VAR connectedness and investment strategies. Resources Policy.

Antonakakis, N., Chatziantoniou, I., & Gabauer, D. (2020). Refined measures of dynamic connectedness based on time-varying parameter vector autoregressions. Journal of Risk and Financial Management.

Antonakakis, N., Cunado, J., Filis, G., Gabauer, D., & de Gracia, F. P. (2020). Oil and asset classes implied volatilities: Investment strategies and hedging effectiveness. Energy Economics.

Antonakakis, N., Chatziantoniou, I., & Gabauer, D. (2021). The impact of Euro through time: Exchange rate dynamics under different regimes. International Journal of Finance & Economics.

Balcilar, M., Gabauer, D., & Umar, Z. (2021). Crude Oil futures contracts and commodity markets: New evidence from a TVP-VAR extended joint connectedness approach. Resources Policy.

Balli, F., Balli, H. O., Dang, T. H. N., & Gabauer, D. (2023). Contemporaneous and lagged R2 decomposed connectedness approach: New evidence from the energy futures market. Finance Research Letters.

Barunik, J., & Krehlik, T. (2018). Measuring the frequency dynamics of financial connectedness and systemic risk. Journal of Financial Econometrics.

Broadstock, D. C., Chatziantoniou, I., & Gabauer, D. (2022). Minimum connectedness portfolios and the market for green bonds: Advocating socially responsible investment (SRI) activity. In Applications in energy finance: The energy sector, economic activity, financial markets and the environment. Cham: Springer International Publishing.

Chatziantoniou, I., & Gabauer, D. (2021). EMU risk-synchronisation and financial fragility through the prism of dynamic connectedness. The Quarterly Review of Economics and Finance.

Chatziantoniou, I., Gabauer, D., & Stenfors, A. (2021). Interest rate swaps and the transmission mechanism of monetary policy: A quantile connectedness approach. Economics Letters.

Chatziantoniou, I., Gabauer, D., & Gupta, R. (2023). Integration and risk transmission in the market for crude oil: New evidence from a time-varying parameter frequency connectedness approach. Resources Policy.

Chatziantoniou, I., Aikins Abakah, E. J., Gabauer, D., & Tiwari, A. K. (2022). Quantile time-frequency price connectedness between green bond, green equity, sustainable investments and clean energy markets. Journal of Cleaner Production.

Chatziantoniou, I., Elsayed, A. H., Gabauer, D., & Gozgor, G. (2023). Oil price shocks and exchange rate dynamics: Evidence from decomposed and partial connectedness measures for oil importing and exporting economies. Energy Economics.

Cocca, T., Gabauer, D., & Pomberger, S. (2024). Clean energy market connectedness and investment strategies: New evidence from DCC-GARCH R2 decomposed connectedness measures. Energy Economics.

Cunado, J., Chatziantoniou, I., Gabauer, D., de Gracia, F. P., & Hardik, M. (2023). Dynamic spillovers across precious metals and oil realized volatilities: Evidence from quantile extended joint connectedness measures. Journal of Commodity Markets.

Diebold, F. X., & Yilmaz, K. (2009). Measuring financial asset return and volatility spillovers, with application to global equity markets. The Economic Journal.

Diebold, F. X., & Yilmaz, K. (2012). Better to give than to receive: Predictive directional measurement of volatility spillovers. International Journal of Forecasting.

Gabauer, D. (2020). Volatility impulse response analysis for DCC-GARCH models: The role of volatility transmission mechanisms. Journal of Forecasting.

Gabauer, D. (2021). Dynamic measures of asymmetric & pairwise connectedness within an optimal currency area: Evidence from the ERM I system. Journal of Multinational Financial Management.

Gabauer, D., Chatziantoniou, I., & Stenfors, A. (2023). Model-free connectedness measures. Finance Research Letters.

Gabauer, D., Gupta, R., Marfatia, H. A., & Miller, S. M. (2024). Estimating US housing price network connectedness: Evidence from dynamic Elastic Net, Lasso, and ridge vector autoregressive models. International Review of Economics & Finance.

Gabauer, D., & Stenfors, A. (2024). Quantile-on-quantile connectedness measures: Evidence from the US treasury yield curve. Finance Research Letters, 60, 104852.

Lastrapes, W. D., & Wiesen, T. F. (2021). The joint spillover index. Economic Modelling, 94, 681-691.

Naeem, M. A., Chatziantoniou, I., Gabauer, D., & Karim, S. (2024). Measuring the G20 stock market return transmission mechanism: Evidence from the R2 connectedness approach. International Review of Financial Analysis.

Stenfors, A., Chatziantoniou, I., & Gabauer, D. (2022). Independent policy, dependent outcomes: A game of cross-country dominoes across European yield curves. Journal of International Financial Markets, Institutions and Money.

Zhang, Y., Gabauer, D., Gupta, R., & Ji, Q. (2024). How connected is the oil-bank network? Firm-level and high-frequency evidence. Energy Economics.
}
\author{
David Gabauer
}
