% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationCKT.kernel.R
\name{se.estimated_CKT_kernel}
\alias{se.estimated_CKT_kernel}
\alias{confint.estimated_CKT_kernel}
\alias{plot.estimated_CKT_kernel}
\title{Methods for class `estimated_CKT_kernel`}
\usage{
\method{se}{estimated_CKT_kernel}(object, progressBar = TRUE, ...)

\method{confint}{estimated_CKT_kernel}(object, parm = NULL, level = 0.95, progressBar = TRUE, ...)

\method{plot}{estimated_CKT_kernel}(
  x,
  confint = NULL,
  level = NULL,
  xlim = NULL,
  ylim = c(-1.2, 1.2),
  progressBar = TRUE,
  color_CKT = "black",
  color_confint = "red",
  ...
)
}
\arguments{
\item{object, x}{an \code{S3} object of class \code{estimated_CKT_kernel}.}

\item{progressBar}{\code{TRUE} if a progress bar is plotted if computations
of standard errors is needed. Note that in some case, the standard error is
already available in the object itself, then no progress bar is needed.}

\item{...}{other arguments, currently passed to \code{plot.default} only for
the \code{plot} method. These are ignored for the other methods.}

\item{parm}{ignored for the moment, kept for compatibility with the generic
\code{confint} method.}

\item{level}{the confidence level for the confidence intervals. By default,
95\% confidence intervals are computed, i.e. \code{level = 0.95}.}

\item{confint}{in case of the \code{plot} method, should confidence bands
also be plotted?}

\item{xlim, ylim}{the x,y limits of the plot.}

\item{color_CKT, color_confint}{the colors respectively for the CKT curve
and for the confidence intervals.}
}
\value{
\code{plot} is only called for its side effect and does not return
anything.

\code{se} returns a vector of the same length as the number of points
in the input \code{newZ} that was given to the function \code{\link{CKT.kernel}}.

\code{confint} returns a matrix with 2 columns and the same number of rows as
the number of points in the input \code{newZ} that was given to the function
\code{\link{CKT.kernel}}.
}
\description{
Methods for class `estimated_CKT_kernel`
}
\examples{
# We simulate from a conditional copula
set.seed(1)
N = 100
# This is a small example for performance reasons.
# For a better example, use:
# N = 800
Z = rnorm(n = N, mean = 5, sd = 2)
conditionalTau = -0.9 + 1.8 * pnorm(Z, mean = 5, sd = 2)
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

newZ = seq(2, 10, by = 1)
estimatedCKT_kernel <- CKT.kernel(
   X1 = X1, X2 = X2, Z = Z,
   newZ = newZ, h = 0.2, kernel.name = "Epa", se = TRUE)

se(estimatedCKT_kernel)
confint(estimatedCKT_kernel, level = 0.9)

plot(estimatedCKT_kernel, confint = TRUE)


}
\seealso{
\code{\link{CKT.kernel}} which generates objects of class
\code{estimated_CKT_kernel}.
}
