% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efflux.R
\name{efflux}
\alias{efflux}
\alias{efflux.cfp_pfres}
\alias{efflux.cfp_fgres}
\alias{efflux.cfp_altres}
\title{Extract efflux rates}
\usage{
efflux(x, ...)

\method{efflux}{cfp_pfres}(x, ...)

\method{efflux}{cfp_fgres}(x, ..., method = "lm", layers = NULL)

\method{efflux}{cfp_altres}(x, ...)
}
\arguments{
\item{x}{A \link{cfp_pfres} or \link{cfp_fgres} model result, or a \link{cfp_altres}.}

\item{...}{Arguments passed to methods.}

\item{method}{Method(s) used to interpolate the efflux at the top of the soil
from partial fluxes within the soil. One of
\describe{
\item{top}{Use the flux in the topmost model layer.}
\item{lm}{A linear model where each partial flux is centered in the
respective layer and the model is evaluated at the top of the soil.}
\item{lex}{Linearly extrapolate using fluxes of two layers in the soil.}
}}

\item{layers}{Vector of two integers selecting the layers for the \code{lex}
method. Layers are indexed from 1 (topmost) to the number of layers used in
the
flux calculation.}
}
\value{
A \code{data.frame} with one row for each
combination of \code{id_cols} and the column \code{efflux}
in \eqn{µmol m^{-2}s^{-1}}.
}
\description{
Calculate or extract the soil/atmosphere efflux
from \code{cfp_pfres} or \code{cfp_fgres} model results.
}
\examples{
my_dat <- ConFluxPro::base_dat |>
  filter(Date < "2021-03-01") #subset to speed up example
PROFLUX <- pro_flux(my_dat)
FLUX <- fg_flux(my_dat)

efflux(PROFLUX)
efflux(FLUX)

}
