% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcdz_layered.R
\name{dcdz_layered}
\alias{dcdz_layered}
\title{dcdz_layered}
\usage{
dcdz_layered(df, layers_map, mode)
}
\arguments{
\item{df}{(dataframe) the gasdata dataframe, filtered to one profile
(e.g. 1 day & one Plot ).}

\item{layers_map}{(dataframe) containing the following parameters:
\itemize{
\item "layer"=name of the layer;
\item "upper"=upper limit of layer in cm;
\item "lower" = lower limit of the layer in cm;}}

\item{mode}{(character) One of ("LL","LS","EF","DA").}
}
\value{
df (dataframe) same structure as layer_map with following columns:
\describe{
\item{mode (character)}{The used gradient method.}
\item{layer (character)}{the layer name}
\item{upper (numeric)}{upper boundary in cm}
\item{lower (numerirc)}{lower boundary in cm}
\item{dcdz_ppm (numeric)}{concentration gradient in ppm/cm.}
\item{dcdz_sd (numeric)}{standard error in ppm/cm.}
\item{dc_ppm (numeric)}{concentration difference in ppm.}
\item{r2}{(linearised) R^2 for the model.}
}
}
\description{
This function calculates concentration gradients using different
approaches.
}
\examples{
{
df <- data.frame(depth = c(10,0,-100),
                 x_ppm = c(400,800,5000),
                 gd_id = c(1,1,1))

lmap <- data.frame(upper = c(10,0),
                   lower = c(0,-100),
                   layer = c("HU","MIN"))
dcdz_layered(df,
             lmap,
             mode = "LL"
)


}

}
\concept{FLUX}
\keyword{internal}
