% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_dat.R
\name{cfp_dat}
\alias{cfp_dat}
\alias{as_cfp_dat}
\alias{as_cfp_dat.cfp_dat}
\title{Model input data}
\usage{
cfp_dat(gasdata, soilphys, layers_map)

as_cfp_dat(x)

\method{as_cfp_dat}{cfp_dat}(x)
}
\arguments{
\item{gasdata}{A cfp_gasdata object created by running \code{cfp_gasdata()}.}

\item{soilphys}{A cfp_soilphys object created by running
\code{cfp_soilphys()}.}

\item{layers_map}{A cfp_layers_map object created by running
\code{cfp_layers_map}.}

\item{x}{An object of class cfp_dat}
}
\value{
A cfp_dat object with the following parameters:
\describe{
\item{gasdata}{The gasdata object with added column "gd_id" that is unique
for each profile.}
\item{soilphys}{The soilphys object with added columns "sp_id" that is unique
for each profile, "step_id" indicating the position of each step from the
bottom up, "height" in m of each layer, "pmap" indicating which layer it
belongs to from the bottom up. Potentially, some original
steps were split to account for the depths within gasdata or layers_map.}
\item{layers_map}{The layers_map object with added column "group_id"
indicating each unique group of the same layer parameterization set
by layers_map.}
\item{profiles}{A \code{data.frame} where each row indicates one unique
profile that is characterised by all \code{id_cols} present in the original
input as well as the corresponding "gd_id", "sp_id", and "group_id". Each
row has a unique identifier "prof_id".}
\item{id_cols}{A character vector of all columns that identify a
profile uniquely.}
}
}
\description{
\code{cfp_dat} is the essential object class that binds all necessary
input data to run a ConFluxPro model. It automatically combines the
different datasets and checks them for validity. It may split soilphys
layers to correspond with layers_map and gasdata depths.
}
\examples{
gasdata <- cfp_gasdata(
  ConFluxPro::gasdata,
  id_cols = c("site", "Date"))
soilphys <- cfp_soilphys(
  ConFluxPro::soilphys,
  id_cols = c("site", "Date"))
layers_map <-
 cfp_layers_map(
   ConFluxPro::layers_map,
   gas = "CO2",
   lowlim = 0,
   highlim = 1000,
   id_cols = "site")
base_dat <- cfp_dat(gasdata, soilphys, layers_map)

### filter similar to dplyr::fliter
filter(base_dat, site == "site_a")
filter(base_dat, prof_id \%in\%  1:5)

### coersion from derived objects
PROFLUX <- pro_flux(base_dat)
as_cfp_dat(PROFLUX)

}
\seealso{
Other data formats: 
\code{\link{cfp_gasdata}()},
\code{\link{cfp_layered_profile}()},
\code{\link{cfp_layers_map}()},
\code{\link{cfp_profile}()},
\code{\link{cfp_soilphys}()}
}
\concept{data formats}
