% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OnePrimerRemove.R
\name{OnePrimerRemove}
\alias{OnePrimerRemove}
\title{Clean biological secuences}
\usage{
OnePrimerRemove(SEQs, PrimerR)
}
\arguments{
\item{SEQs}{dnastring containing biological sequences that are to be cleaned.}

\item{PrimerR}{dnastring containing the reverse primer/vector sequences to be removed.}
}
\value{
clean biological sequences and visualization of the alignments
}
\description{
Curates biological sequences of primer reverse.This cleaning is required for techniques such as cDNA-AFLP.
}
\examples{
SEQs = DNAString(paste("GCCTCGCCTCCCTCTTTGATCAGCTTCGCATATCAGGCAACAGCTCAATTT",
"GGTACTTGTTCAAATAAGCATTTAGACCATCTGTTCCAAGAACCTTTGCAATCTT",
"CACAAGGTGGTCATGGTACGCAGTC", sep=""))
PrimerR= DNAString("GACTGCGTACCATGC")
OnePrimerRemove (SEQs,PrimerR)
}
\author{
Florencia I Pozzi and Silvina A. Felitti
}
