% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{wenchuan_ptsd_matrix}
\alias{wenchuan_ptsd_matrix}
\title{PTSD Symptoms of Wenchuan Earthquake Survivors}
\format{
A matrix with 362 observations and 17 variables:
\describe{
  \item{intrusion}{Symptom: Intrusive thoughts (numeric)}
  \item{dreams}{Symptom: Distressing dreams (numeric)}
  \item{flash}{Symptom: Flashbacks (numeric)}
  \item{upset}{Symptom: Psychological distress (numeric)}
  \item{physior}{Symptom: Physiological reactivity (numeric)}
  \item{avoidth}{Symptom: Avoidance of thoughts (numeric)}
  \item{avoidact}{Symptom: Avoidance of activities (numeric)}
  \item{amnesia}{Symptom: Inability to recall aspects of trauma (numeric)}
  \item{lossint}{Symptom: Loss of interest (numeric)}
  \item{distant}{Symptom: Feeling distant from others (numeric)}
  \item{numb}{Symptom: Emotional numbness (numeric)}
  \item{future}{Symptom: Foreshortened future (numeric)}
  \item{sleep}{Symptom: Sleep disturbances (numeric)}
  \item{anger}{Symptom: Irritability or anger (numeric)}
  \item{concen}{Symptom: Concentration difficulties (numeric)}
  \item{hyper}{Symptom: Hypervigilance (numeric)}
  \item{startle}{Symptom: Exaggerated startle response (numeric)}
}
}
\source{
Data taken from the bgms package version 0.1.4.2
}
\usage{
data(wenchuan_ptsd_matrix)
}
\description{
This dataset, wenchuan_ptsd_matrix, is a matrix containing items measuring symptoms of post-traumatic
stress disorder (PTSD) in survivors of the Wenchuan earthquake. Participants were 362 Chinese adults
who lost at least one child in the disaster. The matrix includes 362 observations and 17 variables,
each representing a symptom of PTSD as assessed by McNally et al. (2015).
}
\details{
The dataset name has been kept as 'wenchuan_ptsd_matrix' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ChinAPIs package and assists users in identifying its specific characteristics.
The suffix 'matrix' indicates that the dataset is a matrix object. The original content has not been modified
in any way.
}
