// Generated by rstantools.  Do not edit by hand.

/*
    CausalQueries is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    CausalQueries is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with CausalQueries.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_simplexes_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 108> locations_array__ =
  {" (found before start of program)",
  " (in 'simplexes', line 51, column 2 to column 49)",
  " (in 'simplexes', line 55, column 2 to column 45)",
  " (in 'simplexes', line 56, column 2 to column 43)",
  " (in 'simplexes', line 57, column 2 to column 38)",
  " (in 'simplexes', line 59, column 2 to column 40)",
  " (in 'simplexes', line 60, column 2 to column 37)",
  " (in 'simplexes', line 61, column 2 to column 44)",
  " (in 'simplexes', line 126, column 2 to column 24)",
  " (in 'simplexes', line 66, column 6 to column 58)",
  " (in 'simplexes', line 65, column 33 to line 67, column 5)",
  " (in 'simplexes', line 65, column 4 to line 67, column 5)",
  " (in 'simplexes', line 74, column 6 to column 80)",
  " (in 'simplexes', line 76, column 13 to column 40)",
  " (in 'simplexes', line 76, column 6 to line 77, column 72)",
  " (in 'simplexes', line 78, column 6 to column 66)",
  " (in 'simplexes', line 72, column 11 to line 79, column 5)",
  " (in 'simplexes', line 70, column 6 to column 26)",
  " (in 'simplexes', line 71, column 6 to column 33)",
  " (in 'simplexes', line 68, column 34 to line 72, column 5)",
  " (in 'simplexes', line 68, column 4 to line 79, column 5)",
  " (in 'simplexes', line 80, column 4 to column 43)",
  " (in 'simplexes', line 63, column 28 to line 81, column 3)",
  " (in 'simplexes', line 63, column 2 to line 81, column 3)",
  " (in 'simplexes', line 85, column 4 to column 24)",
  " (in 'simplexes', line 88, column 6 to line 89, column 66)",
  " (in 'simplexes', line 91, column 6 to column 41)",
  " (in 'simplexes', line 86, column 25 to line 92, column 5)",
  " (in 'simplexes', line 86, column 4 to line 92, column 5)",
  " (in 'simplexes', line 93, column 4 to column 27)",
  " (in 'simplexes', line 84, column 23 to line 94, column 3)",
  " (in 'simplexes', line 84, column 2 to line 94, column 3)",
  " (in 'simplexes', line 96, column 2 to column 17)",
  " (in 'simplexes', line 98, column 2 to column 17)",
  " (in 'simplexes', line 101, column 4 to column 70)",
  " (in 'simplexes', line 100, column 27 to line 102, column 3)",
  " (in 'simplexes', line 100, column 2 to line 102, column 3)",
  " (in 'simplexes', line 133, column 4 to column 37)",
  " (in 'simplexes', line 132, column 9 to line 134, column 3)",
  " (in 'simplexes', line 130, column 6 to column 56)",
  " (in 'simplexes', line 129, column 25 to line 131, column 5)",
  " (in 'simplexes', line 129, column 4 to line 131, column 5)",
  " (in 'simplexes', line 127, column 35 to line 132, column 3)",
  " (in 'simplexes', line 127, column 2 to line 134, column 3)",
  " (in 'simplexes', line 108, column 6 to line 109, column 68)",
  " (in 'simplexes', line 110, column 6 to column 53)",
  " (in 'simplexes', line 107, column 33 to line 111, column 5)",
  " (in 'simplexes', line 107, column 4 to line 111, column 5)",
  " (in 'simplexes', line 106, column 28 to line 112, column 3)",
  " (in 'simplexes', line 106, column 2 to line 112, column 3)",
  " (in 'simplexes', line 115, column 11 to column 52)",
  " (in 'simplexes', line 115, column 4 to line 116, column 50)",
  " (in 'simplexes', line 118, column 4 to column 58)",
  " (in 'simplexes', line 119, column 4 to line 121, column 6)",
  " (in 'simplexes', line 114, column 28 to line 122, column 3)",
  " (in 'simplexes', line 114, column 2 to line 122, column 3)",
  " (in 'simplexes', line 22, column 2 to column 24)",
  " (in 'simplexes', line 23, column 2 to column 23)",
  " (in 'simplexes', line 24, column 2 to column 23)",
  " (in 'simplexes', line 25, column 2 to column 28)",
  " (in 'simplexes', line 26, column 2 to column 23)",
  " (in 'simplexes', line 27, column 2 to column 22)",
  " (in 'simplexes', line 28, column 2 to column 24)",
  " (in 'simplexes', line 29, column 2 to column 28)",
  " (in 'simplexes', line 30, column 2 to column 47)",
  " (in 'simplexes', line 32, column 8 to column 20)",
  " (in 'simplexes', line 32, column 2 to column 48)",
  " (in 'simplexes', line 33, column 18 to column 26)",
  " (in 'simplexes', line 33, column 2 to column 42)",
  " (in 'simplexes', line 35, column 8 to column 20)",
  " (in 'simplexes', line 35, column 2 to column 44)",
  " (in 'simplexes', line 36, column 8 to column 20)",
  " (in 'simplexes', line 36, column 2 to column 42)",
  " (in 'simplexes', line 37, column 8 to column 15)",
  " (in 'simplexes', line 37, column 2 to column 42)",
  " (in 'simplexes', line 38, column 8 to column 15)",
  " (in 'simplexes', line 38, column 2 to column 40)",
  " (in 'simplexes', line 39, column 8 to column 20)",
  " (in 'simplexes', line 39, column 2 to column 51)",
  " (in 'simplexes', line 40, column 8 to column 20)",
  " (in 'simplexes', line 40, column 2 to column 49)",
  " (in 'simplexes', line 42, column 9 to column 17)",
  " (in 'simplexes', line 42, column 19 to column 26)",
  " (in 'simplexes', line 42, column 2 to column 30)",
  " (in 'simplexes', line 43, column 9 to column 17)",
  " (in 'simplexes', line 43, column 19 to column 26)",
  " (in 'simplexes', line 43, column 2 to column 35)",
  " (in 'simplexes', line 44, column 9 to column 16)",
  " (in 'simplexes', line 44, column 18 to column 24)",
  " (in 'simplexes', line 44, column 2 to column 30)",
  " (in 'simplexes', line 45, column 27 to column 35)",
  " (in 'simplexes', line 45, column 37 to column 43)",
  " (in 'simplexes', line 45, column 2 to column 47)",
  " (in 'simplexes', line 47, column 8 to column 16)",
  " (in 'simplexes', line 47, column 2 to column 33)",
  " (in 'simplexes', line 51, column 18 to column 41)",
  " (in 'simplexes', line 55, column 27 to column 35)",
  " (in 'simplexes', line 56, column 18 to column 30)",
  " (in 'simplexes', line 57, column 9 to column 21)",
  " (in 'simplexes', line 59, column 27 to column 34)",
  " (in 'simplexes', line 60, column 27 to column 33)",
  " (in 'simplexes', line 61, column 27 to column 35)",
  " (in 'simplexes', line 126, column 9 to column 16)",
  " (in 'simplexes', line 12, column 4 to column 42)",
  " (in 'simplexes', line 11, column 32 to line 13, column 3)",
  " (in 'simplexes', line 16, column 4 to column 24)",
  " (in 'simplexes', line 17, column 4 to column 44)",
  " (in 'simplexes', line 15, column 36 to line 18, column 3)"};
template <typename T0__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,1,-1>
col_sums(const T0__& X_arg__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>* = nullptr>
stan::promote_args_t<stan::base_type_t<T0__>>
log_sum_exp_stable(const T0__& x_arg__, std::ostream* pstream__);
template <typename T0__,
          stan::require_all_t<stan::is_eigen_matrix_dynamic<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
Eigen::Matrix<stan::promote_args_t<stan::base_type_t<T0__>>,1,-1>
col_sums(const T0__& X_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& X = stan::math::to_ref(X_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    current_statement__ = 103;
    return stan::math::multiply(
             stan::math::rep_row_vector(1, stan::math::rows(X)), X);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
template <typename T0__,
          stan::require_all_t<stan::is_col_vector<T0__>,
                              stan::is_vt_not_complex<T0__>>*>
stan::promote_args_t<stan::base_type_t<T0__>>
log_sum_exp_stable(const T0__& x_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::base_type_t<T0__>>;
  int current_statement__ = 0;
  const auto& x = stan::math::to_ref(x_arg__);
  static constexpr bool propto__ = true;
  // suppress unused var warning
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  // suppress unused var warning
  (void) DUMMY_VAR__;
  try {
    local_scalar_t__ max_x = DUMMY_VAR__;
    current_statement__ = 105;
    max_x = stan::math::max(x);
    current_statement__ = 106;
    return (max_x +
           stan::math::log(
             stan::math::sum(stan::math::exp(stan::math::subtract(x, max_x)))));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
  }
}
#include <stan_meta_header.hpp>
class model_simplexes final : public model_base_crtp<model_simplexes> {
private:
  int n_params;
  int n_paths;
  int n_types;
  int n_param_sets;
  int n_nodes;
  int n_data;
  int n_events;
  int n_strategies;
  int keep_type_distribution;
  std::vector<int> n_param_each;
  Eigen::Matrix<double,-1,1> lambdas_prior_data__;
  std::vector<int> l_starts;
  std::vector<int> l_ends;
  std::vector<int> node_starts;
  std::vector<int> node_ends;
  std::vector<int> strategy_starts;
  std::vector<int> strategy_ends;
  Eigen::Matrix<double,-1,-1> P_data__;
  Eigen::Matrix<double,-1,-1> parmap_data__;
  Eigen::Matrix<double,-1,-1> map_data__;
  Eigen::Matrix<double,-1,-1> E_data__;
  std::vector<int> Y;
  int gamma_1dim__;
  Eigen::Map<Eigen::Matrix<double,-1,1>> lambdas_prior{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> P{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> parmap{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> map{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> E{nullptr, 0, 0};
public:
  ~model_simplexes() {}
  model_simplexes(stan::io::var_context& context__, unsigned int
                  random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_simplexes_namespace::model_simplexes";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 56;
      context__.validate_dims("data initialization", "n_params", "int",
        std::vector<size_t>{});
      n_params = std::numeric_limits<int>::min();
      current_statement__ = 56;
      n_params = context__.vals_i("n_params")[(1 - 1)];
      current_statement__ = 56;
      stan::math::check_greater_or_equal(function__, "n_params", n_params, 1);
      current_statement__ = 57;
      context__.validate_dims("data initialization", "n_paths", "int",
        std::vector<size_t>{});
      n_paths = std::numeric_limits<int>::min();
      current_statement__ = 57;
      n_paths = context__.vals_i("n_paths")[(1 - 1)];
      current_statement__ = 57;
      stan::math::check_greater_or_equal(function__, "n_paths", n_paths, 1);
      current_statement__ = 58;
      context__.validate_dims("data initialization", "n_types", "int",
        std::vector<size_t>{});
      n_types = std::numeric_limits<int>::min();
      current_statement__ = 58;
      n_types = context__.vals_i("n_types")[(1 - 1)];
      current_statement__ = 58;
      stan::math::check_greater_or_equal(function__, "n_types", n_types, 1);
      current_statement__ = 59;
      context__.validate_dims("data initialization", "n_param_sets", "int",
        std::vector<size_t>{});
      n_param_sets = std::numeric_limits<int>::min();
      current_statement__ = 59;
      n_param_sets = context__.vals_i("n_param_sets")[(1 - 1)];
      current_statement__ = 59;
      stan::math::check_greater_or_equal(function__, "n_param_sets",
        n_param_sets, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization", "n_nodes", "int",
        std::vector<size_t>{});
      n_nodes = std::numeric_limits<int>::min();
      current_statement__ = 60;
      n_nodes = context__.vals_i("n_nodes")[(1 - 1)];
      current_statement__ = 60;
      stan::math::check_greater_or_equal(function__, "n_nodes", n_nodes, 1);
      current_statement__ = 61;
      context__.validate_dims("data initialization", "n_data", "int",
        std::vector<size_t>{});
      n_data = std::numeric_limits<int>::min();
      current_statement__ = 61;
      n_data = context__.vals_i("n_data")[(1 - 1)];
      current_statement__ = 61;
      stan::math::check_greater_or_equal(function__, "n_data", n_data, 1);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "n_events", "int",
        std::vector<size_t>{});
      n_events = std::numeric_limits<int>::min();
      current_statement__ = 62;
      n_events = context__.vals_i("n_events")[(1 - 1)];
      current_statement__ = 62;
      stan::math::check_greater_or_equal(function__, "n_events", n_events, 1);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "n_strategies", "int",
        std::vector<size_t>{});
      n_strategies = std::numeric_limits<int>::min();
      current_statement__ = 63;
      n_strategies = context__.vals_i("n_strategies")[(1 - 1)];
      current_statement__ = 63;
      stan::math::check_greater_or_equal(function__, "n_strategies",
        n_strategies, 1);
      current_statement__ = 64;
      context__.validate_dims("data initialization",
        "keep_type_distribution", "int", std::vector<size_t>{});
      keep_type_distribution = std::numeric_limits<int>::min();
      current_statement__ = 64;
      keep_type_distribution = context__.vals_i("keep_type_distribution")[(1
        - 1)];
      current_statement__ = 64;
      stan::math::check_greater_or_equal(function__,
        "keep_type_distribution", keep_type_distribution, 0);
      current_statement__ = 64;
      stan::math::check_less_or_equal(function__, "keep_type_distribution",
        keep_type_distribution, 1);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("n_param_each", "n_param_sets",
        n_param_sets);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "n_param_each", "int",
        std::vector<size_t>{static_cast<size_t>(n_param_sets)});
      n_param_each = std::vector<int>(n_param_sets,
                       std::numeric_limits<int>::min());
      current_statement__ = 66;
      n_param_each = context__.vals_i("n_param_each");
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "n_param_each",
        n_param_each, 1);
      current_statement__ = 67;
      stan::math::validate_non_negative_index("lambdas_prior", "n_params",
        n_params);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "lambdas_prior",
        "double", std::vector<size_t>{static_cast<size_t>(n_params)});
      lambdas_prior_data__ = Eigen::Matrix<double,-1,1>::Constant(n_params,
                               std::numeric_limits<double>::quiet_NaN());
      new (&lambdas_prior)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(lambdas_prior_data__.data(),
        n_params);
      {
        std::vector<local_scalar_t__> lambdas_prior_flat__;
        current_statement__ = 68;
        lambdas_prior_flat__ = context__.vals_r("lambdas_prior");
        current_statement__ = 68;
        pos__ = 1;
        current_statement__ = 68;
        for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
          current_statement__ = 68;
          stan::model::assign(lambdas_prior, lambdas_prior_flat__[(pos__ -
            1)], "assigning variable lambdas_prior",
            stan::model::index_uni(sym1__));
          current_statement__ = 68;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "lambdas_prior",
        lambdas_prior, 0);
      current_statement__ = 69;
      stan::math::validate_non_negative_index("l_starts", "n_param_sets",
        n_param_sets);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "l_starts", "int",
        std::vector<size_t>{static_cast<size_t>(n_param_sets)});
      l_starts = std::vector<int>(n_param_sets,
                   std::numeric_limits<int>::min());
      current_statement__ = 70;
      l_starts = context__.vals_i("l_starts");
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "l_starts", l_starts, 1);
      current_statement__ = 71;
      stan::math::validate_non_negative_index("l_ends", "n_param_sets",
        n_param_sets);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "l_ends", "int",
        std::vector<size_t>{static_cast<size_t>(n_param_sets)});
      l_ends = std::vector<int>(n_param_sets,
                 std::numeric_limits<int>::min());
      current_statement__ = 72;
      l_ends = context__.vals_i("l_ends");
      current_statement__ = 72;
      stan::math::check_greater_or_equal(function__, "l_ends", l_ends, 1);
      current_statement__ = 73;
      stan::math::validate_non_negative_index("node_starts", "n_nodes",
        n_nodes);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "node_starts", "int",
        std::vector<size_t>{static_cast<size_t>(n_nodes)});
      node_starts = std::vector<int>(n_nodes,
                      std::numeric_limits<int>::min());
      current_statement__ = 74;
      node_starts = context__.vals_i("node_starts");
      current_statement__ = 74;
      stan::math::check_greater_or_equal(function__, "node_starts",
        node_starts, 1);
      current_statement__ = 75;
      stan::math::validate_non_negative_index("node_ends", "n_nodes", n_nodes);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "node_ends", "int",
        std::vector<size_t>{static_cast<size_t>(n_nodes)});
      node_ends = std::vector<int>(n_nodes, std::numeric_limits<int>::min());
      current_statement__ = 76;
      node_ends = context__.vals_i("node_ends");
      current_statement__ = 76;
      stan::math::check_greater_or_equal(function__, "node_ends", node_ends,
        1);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("strategy_starts",
        "n_strategies", n_strategies);
      current_statement__ = 78;
      context__.validate_dims("data initialization", "strategy_starts",
        "int", std::vector<size_t>{static_cast<size_t>(n_strategies)});
      strategy_starts = std::vector<int>(n_strategies,
                          std::numeric_limits<int>::min());
      current_statement__ = 78;
      strategy_starts = context__.vals_i("strategy_starts");
      current_statement__ = 78;
      stan::math::check_greater_or_equal(function__, "strategy_starts",
        strategy_starts, 1);
      current_statement__ = 79;
      stan::math::validate_non_negative_index("strategy_ends",
        "n_strategies", n_strategies);
      current_statement__ = 80;
      context__.validate_dims("data initialization", "strategy_ends", "int",
        std::vector<size_t>{static_cast<size_t>(n_strategies)});
      strategy_ends = std::vector<int>(n_strategies,
                        std::numeric_limits<int>::min());
      current_statement__ = 80;
      strategy_ends = context__.vals_i("strategy_ends");
      current_statement__ = 80;
      stan::math::check_greater_or_equal(function__, "strategy_ends",
        strategy_ends, 1);
      current_statement__ = 81;
      stan::math::validate_non_negative_index("P", "n_params", n_params);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("P", "n_types", n_types);
      current_statement__ = 83;
      context__.validate_dims("data initialization", "P", "double",
        std::vector<size_t>{static_cast<size_t>(n_params),
          static_cast<size_t>(n_types)});
      P_data__ = Eigen::Matrix<double,-1,-1>::Constant(n_params, n_types,
                   std::numeric_limits<double>::quiet_NaN());
      new (&P) Eigen::Map<Eigen::Matrix<double,-1,-1>>(P_data__.data(),
        n_params, n_types);
      {
        std::vector<local_scalar_t__> P_flat__;
        current_statement__ = 83;
        P_flat__ = context__.vals_r("P");
        current_statement__ = 83;
        pos__ = 1;
        current_statement__ = 83;
        for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
          current_statement__ = 83;
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            current_statement__ = 83;
            stan::model::assign(P, P_flat__[(pos__ - 1)],
              "assigning variable P", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 83;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 84;
      stan::math::validate_non_negative_index("parmap", "n_params", n_params);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("parmap", "n_paths", n_paths);
      current_statement__ = 86;
      context__.validate_dims("data initialization", "parmap", "double",
        std::vector<size_t>{static_cast<size_t>(n_params),
          static_cast<size_t>(n_paths)});
      parmap_data__ = Eigen::Matrix<double,-1,-1>::Constant(n_params,
                        n_paths, std::numeric_limits<double>::quiet_NaN());
      new (&parmap)
        Eigen::Map<Eigen::Matrix<double,-1,-1>>(parmap_data__.data(),
        n_params, n_paths);
      {
        std::vector<local_scalar_t__> parmap_flat__;
        current_statement__ = 86;
        parmap_flat__ = context__.vals_r("parmap");
        current_statement__ = 86;
        pos__ = 1;
        current_statement__ = 86;
        for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
          current_statement__ = 86;
          for (int sym2__ = 1; sym2__ <= n_params; ++sym2__) {
            current_statement__ = 86;
            stan::model::assign(parmap, parmap_flat__[(pos__ - 1)],
              "assigning variable parmap", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 86;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 87;
      stan::math::validate_non_negative_index("map", "n_paths", n_paths);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("map", "n_data", n_data);
      current_statement__ = 89;
      context__.validate_dims("data initialization", "map", "double",
        std::vector<size_t>{static_cast<size_t>(n_paths),
          static_cast<size_t>(n_data)});
      map_data__ = Eigen::Matrix<double,-1,-1>::Constant(n_paths, n_data,
                     std::numeric_limits<double>::quiet_NaN());
      new (&map) Eigen::Map<Eigen::Matrix<double,-1,-1>>(map_data__.data(),
        n_paths, n_data);
      {
        std::vector<local_scalar_t__> map_flat__;
        current_statement__ = 89;
        map_flat__ = context__.vals_r("map");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
          current_statement__ = 89;
          for (int sym2__ = 1; sym2__ <= n_paths; ++sym2__) {
            current_statement__ = 89;
            stan::model::assign(map, map_flat__[(pos__ - 1)],
              "assigning variable map", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 89;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 90;
      stan::math::validate_non_negative_index("E", "n_events", n_events);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("E", "n_data", n_data);
      current_statement__ = 92;
      context__.validate_dims("data initialization", "E", "double",
        std::vector<size_t>{static_cast<size_t>(n_events),
          static_cast<size_t>(n_data)});
      E_data__ = Eigen::Matrix<double,-1,-1>::Constant(n_events, n_data,
                   std::numeric_limits<double>::quiet_NaN());
      new (&E) Eigen::Map<Eigen::Matrix<double,-1,-1>>(E_data__.data(),
        n_events, n_data);
      {
        std::vector<local_scalar_t__> E_flat__;
        current_statement__ = 92;
        E_flat__ = context__.vals_r("E");
        current_statement__ = 92;
        pos__ = 1;
        current_statement__ = 92;
        for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
          current_statement__ = 92;
          for (int sym2__ = 1; sym2__ <= n_events; ++sym2__) {
            current_statement__ = 92;
            stan::model::assign(E, E_flat__[(pos__ - 1)],
              "assigning variable E", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 92;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 92;
      stan::math::check_greater_or_equal(function__, "E", E, 0);
      current_statement__ = 92;
      stan::math::check_less_or_equal(function__, "E", E, 1);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("Y", "n_events", n_events);
      current_statement__ = 94;
      context__.validate_dims("data initialization", "Y", "int",
        std::vector<size_t>{static_cast<size_t>(n_events)});
      Y = std::vector<int>(n_events, std::numeric_limits<int>::min());
      current_statement__ = 94;
      Y = context__.vals_i("Y");
      current_statement__ = 94;
      stan::math::check_greater_or_equal(function__, "Y", Y, 0);
      current_statement__ = 95;
      gamma_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 95;
      gamma_1dim__ = (n_params - n_param_sets);
      current_statement__ = 95;
      stan::math::validate_non_negative_index("gamma",
        "n_params - n_param_sets", gamma_1dim__);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("lambdas", "n_params", n_params);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("sum_gammas", "n_param_sets",
        n_param_sets);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("log_sum_gammas",
        "n_param_sets", n_param_sets);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("w_0", "n_paths", n_paths);
      current_statement__ = 100;
      stan::math::validate_non_negative_index("w", "n_data", n_data);
      current_statement__ = 101;
      stan::math::validate_non_negative_index("w_full", "n_events", n_events);
      current_statement__ = 102;
      stan::math::validate_non_negative_index("types", "n_types", n_types);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = gamma_1dim__;
  }
  inline std::string model_name() const final {
    return "model_simplexes";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_simplexes_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(gamma_1dim__,
          DUMMY_VAR__);
      current_statement__ = 1;
      gamma = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                gamma_1dim__);
      Eigen::Matrix<local_scalar_t__,-1,1> lambdas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_params, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> sum_gammas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_param_sets,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> log_sum_gammas =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_param_sets,
          DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> w_0 =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_paths, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> w =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_data, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> w_full =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(n_events, DUMMY_VAR__);
      current_statement__ = 23;
      for (int i = 1; i <= n_param_sets; ++i) {
        current_statement__ = 11;
        if (stan::math::logical_gt(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i)))) {
          current_statement__ = 9;
          std::stringstream errmsg_stream__;
          stan::math::stan_print(&errmsg_stream__,
            "Invalid parameter set bounds: start > end");
          throw std::domain_error(errmsg_stream__.str());
        }
        current_statement__ = 20;
        if (stan::math::logical_eq(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i)))) {
          current_statement__ = 17;
          stan::model::assign(sum_gammas, 1.0,
            "assigning variable sum_gammas", stan::model::index_uni(i));
          current_statement__ = 18;
          stan::model::assign(lambdas, 1.0, "assigning variable lambdas",
            stan::model::index_uni(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i))));
        } else {
          current_statement__ = 12;
          stan::model::assign(sum_gammas, (1.0 +
            stan::math::sum(
              stan::model::rvalue(gamma, "gamma",
                stan::model::index_min_max(
                  (stan::model::rvalue(l_starts, "l_starts",
                     stan::model::index_uni(i)) - (i - 1)),
                  (stan::model::rvalue(l_ends, "l_ends",
                     stan::model::index_uni(i)) - i))))),
            "assigning variable sum_gammas", stan::model::index_uni(i));
          current_statement__ = 13;
          stan::math::validate_non_negative_index("raw_params",
            "l_ends[i] - l_starts[i] + 1",
            ((stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i))
            -
            stan::model::rvalue(l_starts, "l_starts",
              stan::model::index_uni(i))) + 1));
          Eigen::Matrix<local_scalar_t__,-1,1> raw_params =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(((stan::model::rvalue(
                                                               l_ends,
                                                               "l_ends",
                                                               stan::model::index_uni(
                                                                 i)) -
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i))) + 1), DUMMY_VAR__);
          current_statement__ = 14;
          stan::model::assign(raw_params,
            stan::math::append_row(1.0,
              stan::model::rvalue(gamma, "gamma",
                stan::model::index_min_max(
                  (stan::model::rvalue(l_starts, "l_starts",
                     stan::model::index_uni(i)) - (i - 1)),
                  (stan::model::rvalue(l_ends, "l_ends",
                     stan::model::index_uni(i)) - i)))),
            "assigning variable raw_params");
          current_statement__ = 15;
          stan::model::assign(lambdas,
            stan::math::divide(raw_params,
              stan::model::rvalue(sum_gammas, "sum_gammas",
                stan::model::index_uni(i))), "assigning variable lambdas",
            stan::model::index_min_max(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i))));
        }
        current_statement__ = 21;
        stan::model::assign(log_sum_gammas,
          stan::math::log(
            stan::model::rvalue(sum_gammas, "sum_gammas",
              stan::model::index_uni(i))),
          "assigning variable log_sum_gammas", stan::model::index_uni(i));
      }
      current_statement__ = 31;
      for (int i = 1; i <= n_paths; ++i) {
        local_scalar_t__ log_prob = DUMMY_VAR__;
        current_statement__ = 24;
        log_prob = 0.0;
        current_statement__ = 28;
        for (int j = 1; j <= n_nodes; ++j) {
          local_scalar_t__ node_prob = DUMMY_VAR__;
          current_statement__ = 25;
          node_prob = stan::math::sum(
                        stan::math::elt_multiply(
                          stan::model::rvalue(lambdas, "lambdas",
                            stan::model::index_min_max(
                              stan::model::rvalue(node_starts, "node_starts",
                                stan::model::index_uni(j)),
                              stan::model::rvalue(node_ends, "node_ends",
                                stan::model::index_uni(j)))),
                          stan::model::rvalue(parmap, "parmap",
                            stan::model::index_min_max(
                              stan::model::rvalue(node_starts, "node_starts",
                                stan::model::index_uni(j)),
                              stan::model::rvalue(node_ends, "node_ends",
                                stan::model::index_uni(j))),
                            stan::model::index_uni(i))));
          current_statement__ = 26;
          log_prob = (log_prob + stan::math::log((node_prob + 1e-10)));
        }
        current_statement__ = 29;
        stan::model::assign(w_0, stan::math::exp(log_prob),
          "assigning variable w_0", stan::model::index_uni(i));
      }
      current_statement__ = 32;
      stan::model::assign(w,
        stan::math::multiply(stan::math::transpose(map), w_0),
        "assigning variable w");
      current_statement__ = 33;
      stan::model::assign(w_full, stan::math::multiply(E, w),
        "assigning variable w_full");
      current_statement__ = 36;
      if (stan::math::logical_lt(stan::math::min(w_full), 1e-10)) {
        current_statement__ = 34;
        std::stringstream errmsg_stream__;
        stan::math::stan_print(&errmsg_stream__,
          "Probabilities too close to zero - numerical instability");
        throw std::domain_error(errmsg_stream__.str());
      }
      current_statement__ = 2;
      stan::math::check_greater_or_equal(function__, "lambdas", lambdas, 0);
      current_statement__ = 2;
      stan::math::check_less_or_equal(function__, "lambdas", lambdas, 1);
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "sum_gammas",
        sum_gammas, 1);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "w_0", w_0, 0);
      current_statement__ = 5;
      stan::math::check_less_or_equal(function__, "w_0", w_0, 1);
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "w", w, 0);
      current_statement__ = 6;
      stan::math::check_less_or_equal(function__, "w", w, 1);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "w_full", w_full, 0);
      current_statement__ = 7;
      stan::math::check_less_or_equal(function__, "w_full", w_full, 1);
      {
        current_statement__ = 49;
        for (int i = 1; i <= n_param_sets; ++i) {
          current_statement__ = 47;
          if (stan::math::logical_lt(
                stan::model::rvalue(l_starts, "l_starts",
                  stan::model::index_uni(i)),
                stan::model::rvalue(l_ends, "l_ends",
                  stan::model::index_uni(i)))) {
            current_statement__ = 44;
            lp_accum__.add(stan::math::dirichlet_lpdf<false>(
                             stan::model::rvalue(lambdas, "lambdas",
                               stan::model::index_min_max(
                                 stan::model::rvalue(l_starts, "l_starts",
                                   stan::model::index_uni(i)),
                                 stan::model::rvalue(l_ends, "l_ends",
                                   stan::model::index_uni(i)))),
                             stan::model::rvalue(lambdas_prior,
                               "lambdas_prior",
                               stan::model::index_min_max(
                                 stan::model::rvalue(l_starts, "l_starts",
                                   stan::model::index_uni(i)),
                                 stan::model::rvalue(l_ends, "l_ends",
                                   stan::model::index_uni(i))))));
            current_statement__ = 45;
            lp_accum__.add((-stan::model::rvalue(n_param_each,
                               "n_param_each", stan::model::index_uni(i)) *
              stan::model::rvalue(log_sum_gammas, "log_sum_gammas",
                stan::model::index_uni(i))));
          }
        }
        current_statement__ = 55;
        for (int i = 1; i <= n_strategies; ++i) {
          current_statement__ = 50;
          stan::math::validate_non_negative_index("strategy_probs",
            "strategy_ends[i] - strategy_starts[i] + 1",
            ((stan::model::rvalue(strategy_ends, "strategy_ends",
                stan::model::index_uni(i)) -
            stan::model::rvalue(strategy_starts, "strategy_starts",
              stan::model::index_uni(i))) + 1));
          Eigen::Matrix<local_scalar_t__,-1,1> strategy_probs =
            Eigen::Matrix<local_scalar_t__,-1,1>::Constant(((stan::model::rvalue(
                                                               strategy_ends,
                                                               "strategy_ends",
                                                               stan::model::index_uni(
                                                                 i)) -
              stan::model::rvalue(strategy_starts, "strategy_starts",
                stan::model::index_uni(i))) + 1), DUMMY_VAR__);
          current_statement__ = 51;
          stan::model::assign(strategy_probs,
            stan::model::rvalue(w_full, "w_full",
              stan::model::index_min_max(
                stan::model::rvalue(strategy_starts, "strategy_starts",
                  stan::model::index_uni(i)),
                stan::model::rvalue(strategy_ends, "strategy_ends",
                  stan::model::index_uni(i)))),
            "assigning variable strategy_probs");
          current_statement__ = 52;
          stan::model::assign(strategy_probs,
            stan::math::divide(stan::model::deep_copy(strategy_probs),
              stan::math::sum(strategy_probs)),
            "assigning variable strategy_probs");
          current_statement__ = 53;
          lp_accum__.add(stan::math::multinomial_lpmf<false>(
                           stan::model::rvalue(Y, "Y",
                             stan::model::index_min_max(
                               stan::model::rvalue(strategy_starts,
                                 "strategy_starts", stan::model::index_uni(i)),
                               stan::model::rvalue(strategy_ends,
                                 "strategy_ends", stan::model::index_uni(i)))),
                           strategy_probs));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_simplexes_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> gamma =
        Eigen::Matrix<double,-1,1>::Constant(gamma_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      gamma = in__.template read_constrain_lb<
                Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__,
                gamma_1dim__);
      Eigen::Matrix<double,-1,1> lambdas =
        Eigen::Matrix<double,-1,1>::Constant(n_params,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> sum_gammas =
        Eigen::Matrix<double,-1,1>::Constant(n_param_sets,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_sum_gammas =
        Eigen::Matrix<double,-1,1>::Constant(n_param_sets,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> w_0 =
        Eigen::Matrix<double,-1,1>::Constant(n_paths,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> w =
        Eigen::Matrix<double,-1,1>::Constant(n_data,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> w_full =
        Eigen::Matrix<double,-1,1>::Constant(n_events,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(gamma);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 23;
      for (int i = 1; i <= n_param_sets; ++i) {
        current_statement__ = 11;
        if (stan::math::logical_gt(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i)))) {
          current_statement__ = 9;
          std::stringstream errmsg_stream__;
          stan::math::stan_print(&errmsg_stream__,
            "Invalid parameter set bounds: start > end");
          throw std::domain_error(errmsg_stream__.str());
        }
        current_statement__ = 20;
        if (stan::math::logical_eq(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i)))) {
          current_statement__ = 17;
          stan::model::assign(sum_gammas, 1.0,
            "assigning variable sum_gammas", stan::model::index_uni(i));
          current_statement__ = 18;
          stan::model::assign(lambdas, 1.0, "assigning variable lambdas",
            stan::model::index_uni(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i))));
        } else {
          current_statement__ = 12;
          stan::model::assign(sum_gammas, (1.0 +
            stan::math::sum(
              stan::model::rvalue(gamma, "gamma",
                stan::model::index_min_max(
                  (stan::model::rvalue(l_starts, "l_starts",
                     stan::model::index_uni(i)) - (i - 1)),
                  (stan::model::rvalue(l_ends, "l_ends",
                     stan::model::index_uni(i)) - i))))),
            "assigning variable sum_gammas", stan::model::index_uni(i));
          current_statement__ = 13;
          stan::math::validate_non_negative_index("raw_params",
            "l_ends[i] - l_starts[i] + 1",
            ((stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i))
            -
            stan::model::rvalue(l_starts, "l_starts",
              stan::model::index_uni(i))) + 1));
          Eigen::Matrix<double,-1,1> raw_params =
            Eigen::Matrix<double,-1,1>::Constant(((stan::model::rvalue(
                                                     l_ends, "l_ends",
                                                     stan::model::index_uni(i))
              -
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i))) + 1),
              std::numeric_limits<double>::quiet_NaN());
          current_statement__ = 14;
          stan::model::assign(raw_params,
            stan::math::append_row(1.0,
              stan::model::rvalue(gamma, "gamma",
                stan::model::index_min_max(
                  (stan::model::rvalue(l_starts, "l_starts",
                     stan::model::index_uni(i)) - (i - 1)),
                  (stan::model::rvalue(l_ends, "l_ends",
                     stan::model::index_uni(i)) - i)))),
            "assigning variable raw_params");
          current_statement__ = 15;
          stan::model::assign(lambdas,
            stan::math::divide(raw_params,
              stan::model::rvalue(sum_gammas, "sum_gammas",
                stan::model::index_uni(i))), "assigning variable lambdas",
            stan::model::index_min_max(
              stan::model::rvalue(l_starts, "l_starts",
                stan::model::index_uni(i)),
              stan::model::rvalue(l_ends, "l_ends", stan::model::index_uni(i))));
        }
        current_statement__ = 21;
        stan::model::assign(log_sum_gammas,
          stan::math::log(
            stan::model::rvalue(sum_gammas, "sum_gammas",
              stan::model::index_uni(i))),
          "assigning variable log_sum_gammas", stan::model::index_uni(i));
      }
      current_statement__ = 31;
      for (int i = 1; i <= n_paths; ++i) {
        double log_prob = std::numeric_limits<double>::quiet_NaN();
        current_statement__ = 24;
        log_prob = 0.0;
        current_statement__ = 28;
        for (int j = 1; j <= n_nodes; ++j) {
          double node_prob = std::numeric_limits<double>::quiet_NaN();
          current_statement__ = 25;
          node_prob = stan::math::sum(
                        stan::math::elt_multiply(
                          stan::model::rvalue(lambdas, "lambdas",
                            stan::model::index_min_max(
                              stan::model::rvalue(node_starts, "node_starts",
                                stan::model::index_uni(j)),
                              stan::model::rvalue(node_ends, "node_ends",
                                stan::model::index_uni(j)))),
                          stan::model::rvalue(parmap, "parmap",
                            stan::model::index_min_max(
                              stan::model::rvalue(node_starts, "node_starts",
                                stan::model::index_uni(j)),
                              stan::model::rvalue(node_ends, "node_ends",
                                stan::model::index_uni(j))),
                            stan::model::index_uni(i))));
          current_statement__ = 26;
          log_prob = (log_prob + stan::math::log((node_prob + 1e-10)));
        }
        current_statement__ = 29;
        stan::model::assign(w_0, stan::math::exp(log_prob),
          "assigning variable w_0", stan::model::index_uni(i));
      }
      current_statement__ = 32;
      stan::model::assign(w,
        stan::math::multiply(stan::math::transpose(map), w_0),
        "assigning variable w");
      current_statement__ = 33;
      stan::model::assign(w_full, stan::math::multiply(E, w),
        "assigning variable w_full");
      current_statement__ = 36;
      if (stan::math::logical_lt(stan::math::min(w_full), 1e-10)) {
        current_statement__ = 34;
        std::stringstream errmsg_stream__;
        stan::math::stan_print(&errmsg_stream__,
          "Probabilities too close to zero - numerical instability");
        throw std::domain_error(errmsg_stream__.str());
      }
      current_statement__ = 2;
      stan::math::check_greater_or_equal(function__, "lambdas", lambdas, 0);
      current_statement__ = 2;
      stan::math::check_less_or_equal(function__, "lambdas", lambdas, 1);
      current_statement__ = 3;
      stan::math::check_greater_or_equal(function__, "sum_gammas",
        sum_gammas, 1);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "w_0", w_0, 0);
      current_statement__ = 5;
      stan::math::check_less_or_equal(function__, "w_0", w_0, 1);
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "w", w, 0);
      current_statement__ = 6;
      stan::math::check_less_or_equal(function__, "w", w, 1);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "w_full", w_full, 0);
      current_statement__ = 7;
      stan::math::check_less_or_equal(function__, "w_full", w_full, 1);
      if (emit_transformed_parameters__) {
        out__.write(lambdas);
        out__.write(sum_gammas);
        out__.write(log_sum_gammas);
        out__.write(w_0);
        out__.write(w);
        out__.write(w_full);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> types =
        Eigen::Matrix<double,-1,1>::Constant(n_types,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 43;
      if (stan::math::logical_eq(keep_type_distribution, 1)) {
        current_statement__ = 41;
        for (int i = 1; i <= n_types; ++i) {
          current_statement__ = 39;
          stan::model::assign(types,
            stan::math::prod(
              stan::math::add(
                stan::math::elt_multiply(
                  stan::model::rvalue(P, "P", stan::model::index_omni(),
                    stan::model::index_uni(i)), lambdas),
                stan::math::subtract(1,
                  stan::model::rvalue(P, "P", stan::model::index_omni(),
                    stan::model::index_uni(i))))),
            "assigning variable types", stan::model::index_uni(i));
        }
      } else {
        current_statement__ = 37;
        stan::model::assign(types, stan::math::rep_vector(1.0, n_types),
          "assigning variable types");
      }
      out__.write(types);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(gamma_1dim__,
          DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(gamma,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(gamma_1dim__),
        "assigning variable gamma");
      out__.write_free_lb(0, gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "gamma", "double",
        std::vector<size_t>{static_cast<size_t>(gamma_1dim__)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> gamma =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(gamma_1dim__,
          DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> gamma_flat__;
        current_statement__ = 1;
        gamma_flat__ = context__.vals_r("gamma");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(gamma, gamma_flat__[(pos__ - 1)],
            "assigning variable gamma", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, gamma);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"gamma"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"lambdas", "sum_gammas", "log_sum_gammas", "w_0", "w", "w_full"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"types"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    gamma_1dim__)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_params)},
             std::vector<size_t>{static_cast<size_t>(n_param_sets)},
             std::vector<size_t>{static_cast<size_t>(n_param_sets)},
             std::vector<size_t>{static_cast<size_t>(n_paths)},
             std::vector<size_t>{static_cast<size_t>(n_data)},
             std::vector<size_t>{static_cast<size_t>(n_events)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(n_types)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        param_names__.emplace_back(std::string() + "sum_gammas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_sum_gammas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        param_names__.emplace_back(std::string() + "w_0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        param_names__.emplace_back(std::string() + "w" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        param_names__.emplace_back(std::string() + "w_full" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
        param_names__.emplace_back(std::string() + "types" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= gamma_1dim__; ++sym1__) {
      param_names__.emplace_back(std::string() + "gamma" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n_params; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambdas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        param_names__.emplace_back(std::string() + "sum_gammas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_param_sets; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_sum_gammas" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_paths; ++sym1__) {
        param_names__.emplace_back(std::string() + "w_0" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_data; ++sym1__) {
        param_names__.emplace_back(std::string() + "w" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= n_events; ++sym1__) {
        param_names__.emplace_back(std::string() + "w_full" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= n_types; ++sym1__) {
        param_names__.emplace_back(std::string() + "types" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(gamma_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"lambdas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_params) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_param_sets) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_param_sets) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w_0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_paths) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_data) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w_full\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_events) + "},\"block\":\"transformed_parameters\"},{\"name\":\"types\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_types) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"gamma\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(gamma_1dim__) + "},\"block\":\"parameters\"},{\"name\":\"lambdas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_params) + "},\"block\":\"transformed_parameters\"},{\"name\":\"sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_param_sets) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_sum_gammas\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_param_sets) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w_0\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_paths) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_data) + "},\"block\":\"transformed_parameters\"},{\"name\":\"w_full\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_events) + "},\"block\":\"transformed_parameters\"},{\"name\":\"types\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(n_types) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = gamma_1dim__;
    const size_t num_transformed = emit_transformed_parameters *
      ((((((n_params + n_param_sets) + n_param_sets) + n_paths) + n_data) +
      n_events));
    const size_t num_gen_quantities = emit_generated_quantities * (n_types);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = gamma_1dim__;
    const size_t num_transformed = emit_transformed_parameters *
      ((((((n_params + n_param_sets) + n_param_sets) + n_paths) + n_data) +
      n_events));
    const size_t num_gen_quantities = emit_generated_quantities * (n_types);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_simplexes_namespace::model_simplexes;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_simplexes_namespace::profiles__;
}
#endif
#endif
