% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catr-code-coords.R
\encoding{UTF-8}
\name{catr_get_code_from_coords}
\alias{catr_get_code_from_coords}
\title{Get the cadastral municipality code from coordinates}
\usage{
catr_get_code_from_coords(
  x,
  srs = NULL,
  verbose = FALSE,
  cache_dir = NULL,
  ...
)
}
\arguments{
\item{x}{It can be:
\itemize{
\item A pair of coordinates \code{c(x,y)}. In this case the \code{srs} of the coordinates
should be provided.
\item A \code{\link[sf:sf]{sf}} object. If the object has several geometries only the
first value will be used. The function will extract the coordinates
using \code{sf::st_centroid(x, of_largest_polygon = TRUE)}.
}}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{ovc_service} column.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{cache_dir}{A path to a cache directory. On \code{NULL} the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{...}{
  Arguments passed on to \code{\link[mapSpain:esp_get_munic_siane]{mapSpain::esp_get_munic_siane}}
  \describe{
    \item{\code{year}}{character string or number. Release year, it must be in
formats \code{YYYY} (assuming end of year) or \code{YYYY-MM-DD}. Historical
information starts as of 2005.}
    \item{\code{resolution}}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item "10": 1:10 million.
\item "6.5": 1:6.5 million.
\item "3": 1:3 million.
}}
    \item{\code{region}}{Optional. A vector of region names, NUTS or ISO codes
(see \code{\link[mapSpain:esp_dict_region_code]{esp_dict_region_code()}}).}
    \item{\code{munic}}{character string. A name or \code{\link[base:grep]{regex}} expression
with the names of the required municipalities. \code{NULL} will return all
municipalities.}
  }}
}
\value{
A \link[tibble:tbl_df-class]{tibble}. See \strong{Details}
}
\description{
This function takes as input a pair of coordinates of a \code{\link[sf:sf]{sf}}
object and returns the corresponding municipality code for those coordinates
using \code{\link[=catr_ovc_get_cod_munic]{catr_ovc_get_cod_munic()}}.
}
\details{
On a successful query, the function returns a \link[tibble:tbl_df-class]{tibble}
with one row including the following columns:
\itemize{
\item \code{munic}: Name of the municipality as per the Cadastre.
\item \code{catr_to}: Cadastral territorial office code.
\item \code{catr_munic}: Municipality code as recorded on the Cadastre.
\item \code{catrcode}: Full Cadastral code for the municipality.
\item \code{cpro}: Province code as per the INE.
\item \code{catr_munic}: Municipality code as per the INE.
\item \code{catrcode}: Full INE code for the municipality.
\item Rest of fields: Check the API Docs.
}
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
# Use with coords
catr_get_code_from_coords(c(-16.25462, 28.46824), srs = 4326)

# Use with sf
prov <- mapSpain::esp_get_prov("Caceres")
catr_get_code_from_coords(prov)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[mapSpain:esp_get_munic_siane]{mapSpain::esp_get_munic_siane()}}, \code{\link[=catr_ovc_get_cod_munic]{catr_ovc_get_cod_munic()}},
\code{\link[sf:geos_unary]{sf::st_centroid()}}.

Other search: 
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_ovc_get_cod_munic}()},
\code{\link{catr_ovc_get_cod_provinces}()}
}
\concept{search}
