% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atom-bu.R
\encoding{UTF-8}
\name{catr_atom_get_buildings}
\alias{catr_atom_get_buildings}
\title{ATOM INSPIRE: Download all buildings of a municipality}
\usage{
catr_atom_get_buildings(
  munic,
  to = NULL,
  what = c("building", "buildingpart", "other"),
  cache = deprecated(),
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{munic}{Municipality to extract. It can be a part of a string or the
cadastral code. See \code{\link[=catr_atom_search_munic]{catr_atom_search_munic()}} for getting the cadastral
codes.}

\item{to}{Optional argument for defining the territorial office to which
\code{munic} belongs. This argument is a helper for narrowing the search.}

\item{what}{Information to load. It can be:
\itemize{
\item \code{"building"} for buildings.
\item \code{"buildingpart"} for parts of a building.
\item \code{"other"} for other elements, such as swimming pools, etc.
}}

\item{cache}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{cache} is no longer
supported; this function will always cache results.}

\item{update_cache}{logical. Should the cached file be refreshed? Default is
\code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{A path to a cache directory. On \code{NULL} the function
would store the cached files on a temporary dir (See \code{\link[base:tempfile]{base::tempdir()}}).}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Retrieve the spatial data of all buildings belonging to a single municipality
using the INSPIRE ATOM service.
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
s <- catr_atom_get_buildings("Nava de la Asuncion", to = "Segovia")

library(ggplot2)
ggplot(s) +
  geom_sf() +
  coord_sf(
    xlim = c(374500, 375500),
    ylim = c(4556500, 4557500)
  ) +
  labs(
    title = "Buildings",
    subtitle = "Nava de la Asuncion, Segovia"
  )
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.catastro.hacienda.gob.es/webinspire/documentos/inspire-ATOM.pdf}{API Documentation}.

\href{https://www.catastro.hacienda.gob.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}.
}
\seealso{
INSPIRE API functions:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()},
\code{\link{inspire_wfs_get}()}

Other INSPIRE ATOM services:
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_search_munic}()}

Other buildings: 
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_wfs_get_buildings_bbox}()}

Other spatial: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wfs_get_parcels_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{ATOM}
\concept{INSPIRE}
\concept{buildings}
\concept{spatial}
