% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{proximity_distance}
\alias{proximity_distance}
\title{Get proximity matrix of an ranger object}
\usage{
proximity_distance(x, y = NULL, rfObject, as_dist = TRUE)
}
\arguments{
\item{x}{a new dataset}

\item{y}{a second new dataset (Default: NULL)}

\item{rfObject}{\code{ranger} object}

\item{as_dist}{Bool, return a dist object.}
}
\value{
a \code{dist} or a matrix object with pairwise proximity of
observations in x vs y (if not null)
}
\description{
Get proximity matrix of an ranger object
}
\examples{
\donttest{
library(ranger)
rf <- ranger(Species ~ ., data = iris, num.trees = 5, write.forest = TRUE)
proximity_distance(x = iris[, -5], rfObject = rf)

set.seed(1234L)
learn <- sample(1:150, 100)
test <- (1:150)[-learn]
rf <- ranger(Species ~ ., data = iris[learn, ], num.trees = 500, write.forest = TRUE)
proximity_distance(x = iris[learn, -5], y = iris[test, -5], rfObject = rf)
}
}
