% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTE.R
\name{CTE}
\alias{CTE}
\title{Calculate Constant Temperature Equivalent (CTE)}
\usage{
CTE(M, R, T0 = 0, t = pi, max.it = 10000)
}
\arguments{
\item{M}{(integer) Mean temperature for a given day in degrees centigrade}

\item{R}{(integer) Maximum deviation of temperatures from M for a given day in degrees centigrade (e.g., if the range of temperatures is 14‒25 and M = 20, then R = 6)}

\item{T0}{(integer) Temperature in degrees centigrade below which no development will occur. Default = 0.}

\item{t}{(integer; 0 < t < 2pi) Starting seed for calculating the point along the curve above which half of development occurs. Any value > 0 and < 2pi will work. Default = pi.}

\item{max.it}{(numeric) Maximum number of times the function will try to find a solution for a given day. In rare cases, no stable solution exists, in which case it will attempt to find a solution max.it number of times before returning NA. Default = 10000}
}
\value{
Numeric value of the CTE for a given day (in degrees centigrade)
}
\description{
Calculate daily constant temperature equivalents
}
\details{
CTE takes input values for a given day and returns the CTE using the formulas in Georges (1989). It automatically selects the appropriate formula based on whether the minimum temperature (M-R) is less than T0. T0 may not be precisely known in all cases, but should be estimated based on knowledge of the species being studied. If you think your nest never dropped below T0 (i.e., there was not point at which development was not occurring) then set T0 lower than your minimum temperature. If M+R < T0 (i.e., all temps on a given day were less than T0, then T0 is returned as CTE). Because this function operates on data from a single day, in most cases you will want to loop it over your nests and dates to get a CTE per nest per date. You can accomplish this with a for loop or functions in packages like dplyr and plyr. See Vignette for details on the formulas and examples.
}
\examples{
CTE(M=20, R = 6, T0=10)
}
\references{
Georges, A. (1989).
*Female turtles from hot nests: is it duration of incubation or proportion of development at high temperatures that matters?*.
Oecologia, **81**, 323-328
}
