% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LICbeta.R
\name{LICbeta}
\alias{LICbeta}
\title{Calculate the LIC estimator for linear regression}
\usage{
LICbeta(X, Y, alpha, K, nk)
}
\arguments{
\item{X}{The observation matrix (n x p)}

\item{Y}{The response vector (n x 1)}

\item{alpha}{The significance level for computing confidence intervals}

\item{K}{The number of subsets}

\item{nk}{The number of observations per subset}
}
\value{
A list containing:
\item{E5}{The LIC estimator for linear regression.}
}
\description{
This function estimates the coefficients of a linear regression model using a design matrix `X` and a response vector `Y`. It implements an A-optimal and D-optimal design criteria to choose optimal subsets of observations.
}
\references{
Guo, G., Song, H. & Zhu, L. The COR criterion for optimal subset selection in distributed estimation. \emph{Statistics and Computing}, 34, 163 (2024). \doi{10.1007/s11222-024-10471-z}
}
