% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naive_jags_picker.R
\name{naive_jags_picker}
\alias{naive_jags_picker}
\title{Set up a Naive Logistic Regression \code{jags.model} Object for a Given Prior}
\usage{
naive_jags_picker(
  prior,
  sample_size,
  dim_x,
  n_cat,
  Ystar,
  X,
  beta_prior_parameters,
  number_MCMC_chains,
  naive_model_file,
  display_progress = TRUE
)
}
\arguments{
\item{prior}{character string specifying the prior distribution for the naive
\eqn{\beta} parameters. Options are \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"} (double Exponential, or Weibull).}

\item{sample_size}{An integer value specifying the number of observations in the sample.}

\item{dim_x}{An integer specifying the number of columns of the design matrix of the true outcome mechanism, \code{X}.}

\item{n_cat}{An integer specifying the number of categorical values that the true outcome, \code{Y},
and the observed outcome, \code{Y*} can take.}

\item{Ystar}{A numeric vector of indicator variables (1, 2) for the observed
outcome \code{Y*}. The reference category is 2.}

\item{X}{A numeric design matrix for the true outcome mechanism.}

\item{beta_prior_parameters}{A numeric list of prior distribution parameters
for the \eqn{\beta} terms. For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the first element of the
list should contain a matrix of location, lower bound, mean, or shape parameters,
respectively, for \eqn{\beta} terms.
For prior distributions \code{"t"},
\code{"uniform"}, \code{"normal"}, or \code{"dexp"}, the second element of the
list should contain a matrix of shape, upper bound, standard deviation, or scale parameters,
respectively, for \eqn{\beta} terms.
For prior distribution \code{"t"}, the third element of the list should contain
a matrix of the degrees of freedom for \eqn{\beta} terms.
The third list element should be empty for all other prior distributions.
All matrices in the list should have dimensions \code{dim_x} X \code{n_cat}, and all
elements in the \code{n_cat} column should be set to \code{NA}.}

\item{number_MCMC_chains}{An integer specifying the number of MCMC chains to compute.}

\item{naive_model_file}{A .BUG file and used
for MCMC estimation with \code{rjags}.}

\item{display_progress}{A logical value specifying whether messages should be
displayed during model compilation. The default is \code{TRUE}.}
}
\value{
\code{naive_jags_picker} returns a \code{jags.model} object for a naive
logistic regression model predicting the potentially misclassified \code{Y*}
from the predictor matrix \code{x}. The object includes the specified
prior distribution, model, number of chains, and data.
}
\description{
Set up a Naive Logistic Regression \code{jags.model} Object for a Given Prior
}
