% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSigExposure.R
\name{plotSigExposure}
\alias{plotSigExposure}
\title{plotSigExposure}
\usage{
plotSigExposure(
  sigExposure,
  saveRes = FALSE,
  saveDir = NULL,
  runName = "",
  trackData = NULL,
  sort = FALSE,
  sortOrder = "m",
  method = NULL,
  colors = NULL
)
}
\arguments{
\item{sigExposure}{Signature exposure matrix to be plotted}

\item{saveRes}{Whether or not to save results. Default is FALSE.}

\item{saveDir}{Where to save plots, must be provided if using saveDir}

\item{runName}{Used to add a runName to the file output. Default is "".}

\item{trackData}{Data used to plot tracks}

\item{sort}{Whether or not to sort the plot}

\item{sortOrder}{The order in which to sort the plot}

\item{method}{The method by which to sort the main plot}

\item{colors}{Colors used in plotting}
}
\value{
Plots the signature exposure to allow visualization
}
\description{
This function plots the signature exposure for all of the samples as a
stacked bar plot. There are a number of different options for how to sort 
the resulting plot.
}
\details{
Adding data tracks to the plot:
One of the major features of this function is that it allows the user to add
in some additional data for the samples to be plotted as a track alongside 
the main signature exposure stacked bar plot. These additional data points 
can be passed in as a vector of corresponding values in the same order. If
you want to plot multiple tracks you can pass in a list of vectors using 
the trackData parameter.

Specifying how to sort the plot:
When you give the function a set of trackData, it allows you to begin to 
specify the sortOrder. This allows your to sort the main plot in a different 
order. "m" represents the main plot, and "t" followed by the number of the 
track (ie: "t1","t2" ...)  represents the tracks. By chaining the values 
together you can specify a variety of ways to sort the final plot. As an
example, the sortOrder of "mt1t2" specifies the the plot should be sorted by 
the signature exposures first followed by the first track and finally the 
second track. In another example, the sortOrder of "t2mt1" specifies the plot
to be sorted by track number 2 first followed by the signature exposures and 
lastly by track number 1.

Sorting method:
The two methods of sorting the signature exposure are either "hclust" or 
"group". The hclust uses the ward.D method to cluster the exposures and then
cuts the tree to split the data. The group method splits the samples into
groups based on which signatures they had the highest exposure to.
}
\examples{
\donttest{plotSigExposure(sigExposExp)}
}
\keyword{plot}
\keyword{sigExposure}
