% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_function.R
\name{CIM}
\alias{CIM}
\title{Compositional Impact of Migration}
\usage{
CIM(..., calculation, numerator, denominator, DuncanAll = TRUE,
  rest = TRUE)
}
\arguments{
\item{...}{2 or more data frames, each containing an origin-destination migration matrix by
population attribute (i.e. age, sex, education, ethnicity, etc.).
Columns are expected to represent origins,
and rows are expected to represent destionations. The first row and column are assumed to
contain labels for each area.}

\item{calculation}{a character, indicating the migration impact indicator selected to measure the socio-demographic
composition of an area. Users can type one of three options:
"ratio", "percentage" or "duncan".}

\item{numerator}{a number, indicating the index number of the data frame to be used as
the numerator for the calculation. Type 1 to use the first data frame included in the function.
Type 2 to use the second data frame included in the function, and so on.}

\item{denominator}{a number, indicating the index number of the data frame to be used as
the denominator for the calculation. Type 1 to use the first data frame included in the function.
Type 2 to use the second data frame included in the function, and so on.
Note the numerator data frame must differ from the denominator data frame.}

\item{DuncanAll, }{a logical argument. If calculation = "Duncan", this logical argument must be specified.
The Duncan index measures the dissimilarity in the spatial
distribution of a chosen group (first data frame in the function) against a reference category
as specified by the "DuncanAll" argument.
If TRUE, the reference category is the sum of all data frames,
except for the first data frame included in the function (i.e. chosen group).
If FALSE, a specific data frame must be specified to be the reference group. See Duncan and Duncan (1955)
for details on the Duncan index, and Rodríguez-Vignoli and Rowe (2017a, b) for an empirical application
of the CIM using the Duncan index.}

\item{rest, }{a logical argument. If calculation = "Duncan", this argument must be specified.
It enables a special calculation of the CIM, for a particular area (e.g. the Greater London Metropolitan Area), and
the rest of spatial units comprising a country. To correctly compute the CMI, these spatial units
need to be amalgamated and included as a single column/row in the matrix - labelled "Rest of the country"
(e.g. Rest of the UK). If TRUE, the column/row of the "Rest of the country" is considered for the calculation
and is excluded from the denominator of the duncan index.
If FALSE, the "Rest of the country" column/row is included in the denominator, producing the wrong results.}
}
\value{
an object containing:

for the "ratio" and "percentage" calculation options:

num_results: a data frame containing nine area-level indicators: the Factual Value (FV), Counterfactual Value (CFV),
Compositional Impact of Migration (CIM), Compositional Impact of Migration Percentage Change (CIM_PC),
Diagonal Cell Indicator (DIAG), Compositional Impact of Migration for Inflows (CIM_I),
Compositional Impact of Migration for Outflows (CIM_O), CIM_I as a percentage of CMI (CIM_I_PC), and
CIM_O as a percentage of CMI (CIM_O_PC)

for the "duncan" calculation option:

duncan_results: a data frame, containing
the Factual Value of the Area-Specific Share (ASFVShare_cg), and the Counterfactual Value of the Area-Specific Share (ASCFVShare_cg) for the chosen group;
the Factual Value of the Area-Specific Share (ASFVShare_ref) and the Counterfactual Value of the Area-Specific Share (ASCFVShare_ref) for the reference group;
the Area-Specific Share Factual Value Difference between the ASFVShare_cg and ASFVShare_ref (ASShareFV_diff);
and the Area-Specific Share Counterfactual Value Difference between the ASCFVShare_cg and ASCFVShare_ref (ASShareCFV_diff).
The chosen group corresponds to the first data frame in the function. See above the argument "DuncanAll"
to specify the reference category.

duncan_index: a numeric value, indicating the Duncan Index of dissimilarity for the chosen group.
}
\description{
produce statistical indicators of the impact of migration on the socio-demographic
composition of an area. Three measures can be used: ratios, percentages and
 the Duncan index of dissimilarity. The input data files are assumed to be in an
origin-destination matrix format, with each cell representing a flow count
between an origin and a destination area. Columns are expected to represent origins,
and rows are expected to represent destinations. The first row and column are assumed to
contain labels for each area. See Rodríguez-Vignoli and Rowe (2018)
for technical details.
}
\examples{
## Read in the two data.frames included in the package
m <- male
f <- female

## Run the function using "ratio" calculation
CIM.ratio <- CIM(m, f, calculation = "ratio", numerator = 1, denominator = 2)
## Print the resulted data.frame
CIM.ratio

## Run the function using "percentage" calculation
CIM.percentage <- CIM(m, f, calculation = "percentage", numerator = 1, denominator = 2)
## See the resulted data.frame
CIM.percentage

## For the Duncan index, we compute impact of internal migration on the spatial pattern of
## residential age segregation of people age 65 and over in the
## local authority districts of Greater London using 2011 census data.
## Chosen group: people aged 65 and over.
## Reference category: the rest of age groups.
## For this example, this group is people aged pop1-14, 15-29, 30-14 and 45-64).
CIM.duncan <- CIM(pop65over, pop1_14, pop15_29, pop30_44, pop45_64,
calculation = "duncan", numerator = 1, DuncanAll= TRUE)
CIM.duncan$duncan_results
CIM.duncan$duncan_index


}
\references{
Duncan, O.D. and Duncan, B., 1955. A methodological analysis of segregation indexes.
American sociological review, 20(2), pp.210-217.

Rodríguez-Vignoli, J.R. and Rowe, F., 2017a. ¿Contribuye la migración interna a
reducir la segregación residencial?: el caso de Santiago de Chile 1977-2002.
Revista Latinoamericana de Población, (21), pp.7-46.

Rodríguez-Vignoli, J.R. and Rowe, F., 2017b. The Changing Impacts of Internal Migration
on Residential Socio-Economic Segregation in the Greater Santiago. 28th International
Population Conference of the International Union for the Scientific Study of Population (IUSSP),
 Cape Town, South Africa.

Rodríguez-Vignoli, J. and Rowe, F., 2018. How is internal migration reshaping
metropolitan populations in Latin America? A new method and new evidence.
Population studies, 72(2), pp.253-273. doi.org/10.1080/00324728.2017.1416155
}
