% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimaterating.R
\name{estimaterating}
\alias{estimaterating}
\title{Recommendation Functions}
\usage{
estimaterating(
  CF,
  Id_u,
  Id_i,
  type = "user",
  neighbors = ifelse(type == "user", nrow(CF$MU) - 1, ncol(CF$MU) - 1)
)
}
\arguments{
\item{CF}{A CF object}

\item{Id_u}{the user Id}

\item{Id_i}{the item Id}

\item{type}{"user" or "item"}

\item{neighbors}{number of neighbors in the calculation.}
}
\description{
Function that provide an estimate of the user's rating
for the item.
}
\examples{
objectCF_r <- CFbuilder(Data = movies[1:500,], Datatype = "ratings", 
similarity = "cosine")
estimaterating(CF=objectCF_r,Id_u="35",Id_i="Despicable Me 2")
estimaterating(CF=objectCF_r,Id_u="35",Id_i="Her")
}
\author{
Jessica Kubrusly
}
