% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_thermal_montage}
\alias{plot_thermal_montage}
\title{Create a Gap-Free Thermal Image Montage}
\usage{
plot_thermal_montage(
  img_list,
  ncol = NULL,
  padding = 10,
  palette = "inferno",
  text_color = "black",
  text_size = 4
)
}
\arguments{
\item{img_list}{A list of 'BioThermR' objects (e.g., output from \code{read_thermal_batch} or \code{roi_filter_interactive}).}

\item{ncol}{Integer. The number of columns in the grid. If \code{NULL} (default), it is automatically calculated
based on the square root of the number of images to create a roughly square layout.}

\item{padding}{Integer. The size of the whitespace gap (in pixels) between grid cells. Default is 10.}

\item{palette}{String. The color palette to use (from 'viridis' package). Default is "inferno".}

\item{text_color}{String. Color of the filename labels. Default is "black".}

\item{text_size}{Integer. Font size for the filename labels. Default is 4.}
}
\value{
A \code{ggplot} object representing the combined montage.
}
\description{
Combines a list of 'BioThermR' objects into a single, high-resolution grid plot (montage).
             Unlike standard faceting, this function uses a custom integer-coordinate system to
             center each subject within a uniform grid cell, ensuring pixel-perfect alignment
             without the visual artifacts (white gaps) often seen in R raster plots.
}
\details{
The function executes a two-pass algorithm:
         \enumerate{
           \item \strong{Scan Pass:} Iterates through all objects to calculate the bounding box dimensions
                 of the largest subject. This defines the uniform cell size for the grid.
           \item \strong{Layout Pass:} Calculates the integer offsets required to center each smaller subject
                 within the master cell. It merges all pixel data into a single master data frame.
         }
         The result is rendered using \code{geom_tile(width=1, height=1)} to guarantee continuous, gap-free visualization.
}
\examples{
\donttest{
# Load a batch of images
img_obj_list <- system.file("extdata",package = "BioThermR")
batch <- read_thermal_batch(img_obj_list)

# Create a montage with 4 columns
p <- plot_thermal_montage(batch, ncol = 4, padding = 20)
}
}
