% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMFit.R
\name{cvEM}
\alias{cvEM}
\title{Cross-validation for the EM algorithm}
\usage{
cvEM(
  ni,
  si,
  ti = NULL,
  N_cv = NULL,
  N_init = 20,
  maxIter = 1000,
  errorMin = 1e-07,
  prior = list(a_FP = 2, b_FP = 2, a_FN = 2, b_FN = 2)
)
}
\arguments{
\item{ni}{Numeric vector of \eqn{n_i}'s, the total numbers of replicates for each individual}

\item{si}{Numeric vector of \eqn{s_i}'s, the numbers of replicates equal to 1 for each individual}

\item{ti}{Numeric vector of \eqn{t_i}'s, the true values of the binary variable for each individual.
If \code{NULL}, the EM algorithm is used to estimate the parameters. Defaults to \code{NULL}. See details.}

\item{N_cv}{The number of folds. Defaults to 20.}

\item{N_init}{The number of initializations if \code{ti} is not provided. Defaults to 20.}

\item{maxIter}{The maximum number of iterations if the EM algorithm is used. Defaults to 1e3.}

\item{errorMin}{The minimum error for convergence if the EM algorithm is used. Defaults to 1e-7.}

\item{prior}{A list of prior parameters for the model.}
}
\value{
A list with the following components:
\describe{
\item{models}{ A list of the models for each fold}
\item{predictions}{ A list of the predictions for each fold}
}
}
\description{
Cross-validation for the EM algorithm
}
\details{
This function chooses its algorithm according to what is provided in the \code{ti} argument:
\describe{
\item{\code{ti} is fully provided}{The function computes the \emph{Maximum-A-Posteriori}
estimate, with an explicit formula.}
\item{\code{ti} is not provided}{The function uses the EM algorithm
to estimate the parameters.}
\item{\code{ti} is partially provided}{The function uses the EM algorithm to
estimate the parameters.}
}
}
\examples{
data("periodontal")
modelCV <- cvEM(periodontal$ni, periodontal$si)

}
\seealso{
\link{classify_with_scores}, \link{EMFit}
}
