% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.sim.R
\name{data.sim}
\alias{data.sim}
\title{High Dimensional Correlated Data Generation}
\usage{
data.sim(n = 100, p = 1000, pr = 3, cor = 0.6)
}
\arguments{
\item{n}{sample size}

\item{p}{total number of variables}

\item{pr}{the number of variables related to the response}

\item{cor}{the maximum correlation between related and unrelated variables}
}
\value{
Returns an nxp matrix with the first pr columns having maximum correlation cor with
        the remaining p-pr columns
}
\description{
Generates an high dimensional dataset with a subset of columns being related to the response, while
controlling the maximum correlation between related and unrelated variables.
}
\examples{
data=data.sim(n=100,p=1000,pr=10,cor=.6)
max(abs(cor(data))[abs(cor(data))<1])

}

