/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.rejection;

import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.rejection.AcceptCondition;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class RejectionOperator
extends SimpleMCMCOperator {
    private final RejectionProvider gibbsOp;
    private final AcceptCondition condition;
    private static final String REJECTION_OPERATOR = "rejectionOperator";
    private static final String CONDITION = "condition";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            RejectionProvider rejectionProvider = (RejectionProvider)xMLObject.getChild(RejectionProvider.class);
            double d = xMLObject.getAttribute("weight", rejectionProvider.getWeight());
            AcceptCondition acceptCondition = null;
            if (xMLObject.hasAttribute(RejectionOperator.CONDITION)) {
                String string = xMLObject.getStringAttribute(RejectionOperator.CONDITION);
                for (AcceptCondition.SimpleAcceptCondition simpleAcceptCondition : AcceptCondition.SimpleAcceptCondition.values()) {
                    if (!string.equalsIgnoreCase(simpleAcceptCondition.getName())) continue;
                    acceptCondition = simpleAcceptCondition;
                    break;
                }
                if (acceptCondition == null) {
                    throw new XMLParseException("Unrecognized condition type: " + string);
                }
            } else {
                acceptCondition = (AcceptCondition)xMLObject.getChild(AcceptCondition.class);
            }
            return new RejectionOperator(rejectionProvider, acceptCondition, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(RejectionProvider.class), new XORRule(AttributeRule.newStringRule(RejectionOperator.CONDITION), new ElementRule(AcceptCondition.class)), AttributeRule.newDoubleRule("weight", true)};
        }

        @Override
        public String getParserDescription() {
            return "A rejection sampler that always accepts a Gibbs proposal if a condition is met (and always rejects otherwise)";
        }

        @Override
        public Class getReturnType() {
            return RejectionOperator.class;
        }

        @Override
        public String getParserName() {
            return RejectionOperator.REJECTION_OPERATOR;
        }
    };

    public RejectionOperator(RejectionProvider rejectionProvider, AcceptCondition acceptCondition, double d) {
        this.setWeight(d);
        this.gibbsOp = rejectionProvider;
        this.condition = acceptCondition;
    }

    @Override
    public String getOperatorName() {
        return REJECTION_OPERATOR;
    }

    @Override
    public double doOperation() {
        double[] dArray = this.gibbsOp.getProposedUpdate();
        if (this.condition.satisfiesCondition(dArray)) {
            Parameter parameter = this.gibbsOp.getParameter();
            for (int i = 0; i < parameter.getDimension(); ++i) {
                parameter.setParameterValueQuietly(i, dArray[i]);
            }
            parameter.fireParameterChangedEvent();
            return Double.POSITIVE_INFINITY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public static interface RejectionProvider
    extends GibbsOperator {
        public double[] getProposedUpdate();

        public Parameter getParameter();
    }
}

