/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.distribution.AutoRegressiveNormalDistributionModel;
import dr.inference.distribution.CompoundSymmetryNormalDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import java.util.HashMap;
import java.util.Map;

public interface PrecisionColumnProvider {
    public double[] getColumn(int var1);

    public static class CompoundSymmetry
    extends Base {
        private final CompoundSymmetryNormalDistributionModel cs;

        public CompoundSymmetry(CompoundSymmetryNormalDistributionModel compoundSymmetryNormalDistributionModel, boolean bl) {
            super("precisionColumnProvider.CompoundSymmetry", bl);
            this.cs = compoundSymmetryNormalDistributionModel;
            this.addModel(compoundSymmetryNormalDistributionModel);
        }

        @Override
        double[] getColumnWithoutCache(int n) {
            return this.cs.getPrecisionColumn(n);
        }
    }

    public static class AutoRegressive
    extends Base {
        private final AutoRegressiveNormalDistributionModel ar;

        public AutoRegressive(AutoRegressiveNormalDistributionModel autoRegressiveNormalDistributionModel, boolean bl) {
            super("precisionColumnProvider.AutoRegressive", bl);
            this.ar = autoRegressiveNormalDistributionModel;
            this.addModel(autoRegressiveNormalDistributionModel);
        }

        @Override
        double[] getColumnWithoutCache(int n) {
            return this.ar.getPrecisionColumn(n);
        }
    }

    public static class Generic
    extends Base {
        private final MatrixParameterInterface matrix;

        public Generic(MatrixParameterInterface matrixParameterInterface, boolean bl) {
            super("precisionColumnProvider.Generic", bl);
            this.matrix = matrixParameterInterface;
            this.addVariable(matrixParameterInterface);
        }

        @Override
        double[] getColumnWithoutCache(int n) {
            int n2 = this.matrix.getRowDimension();
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = this.matrix.getParameterValue(i, n);
            }
            return dArray;
        }
    }

    public static abstract class Base
    extends AbstractModel
    implements PrecisionColumnProvider {
        private final Map<Integer, double[]> cache = new HashMap<Integer, double[]>();
        private final boolean useCache;

        private Base(String string, boolean bl) {
            super(string);
            this.useCache = bl;
        }

        @Override
        protected void handleModelChangedEvent(Model model, Object object, int n) {
            this.cache.clear();
        }

        @Override
        protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            this.cache.clear();
        }

        @Override
        public double[] getColumn(int n) {
            if (this.useCache) {
                if (!this.cache.containsKey(n)) {
                    this.cache.put(n, this.getColumnWithoutCache(n));
                }
                return this.cache.get(n);
            }
            return this.getColumnWithoutCache(n);
        }

        @Override
        protected void storeState() {
        }

        @Override
        protected void restoreState() {
        }

        @Override
        protected void acceptState() {
        }

        abstract double[] getColumnWithoutCache(int var1);
    }
}

