% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.BayesSurvive.R
\name{predict.BayesSurvive}
\alias{predict.BayesSurvive}
\title{Predict survival risk}
\usage{
\method{predict}{BayesSurvive}(
  object,
  survObj.new,
  type = "brier",
  method = "mean",
  times = NULL,
  subgroup = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{fitted object obtained with \code{BayesSurvive}}

\item{survObj.new}{a list containing observed data from new subjects with
components \code{t}, \code{di}, \code{x}. If \code{type} is among
\code{c("hazard", "cumhazard", "survival")}, only \code{survObj.new$X} is
needed.}

\item{type}{option to chose for predicting brier scores with \code{type="brier"}
or one of \code{type=c("brier", "hazard", "cumhazard", "survival")})}

\item{method}{option to use the posterior mean (\code{"mean"}) of coefficients
for prediction or Bayesian model averaging (\code{"BMA"}) for prediction}

\item{times}{time points at which to evaluate the risks. If \code{NULL}
(default), the event/censoring times are used. If \code{type="brier"}, the
largest one of the \code{times} is used}

\item{subgroup}{index of the subgroup in \code{survObj.new} for prediction.
Default value is 1}

\item{verbose}{logical value to print IBS of the NULL model and the Bayesian
Cox model}

\item{\dots}{not used}
}
\value{
A list object with 5 components if \code{type="brier"} including
"model", "times", "Brier", "IBS" and "IPA" (Index of Prediction Accuracy),
otherwise  a list of 7 components with the first component as
the specified argument \code{type} and "se", "band", "type", "diag",
"baseline" and "times", see function \code{riskRegression::predictCox} for
details
}
\description{
Predict survival probability, (cumulative) hazard or (integrated) Brier
scores based on Cox regression models
}
\examples{

library("BayesSurvive")
set.seed(123)

# Load the example dataset
data("simData", package = "BayesSurvive")

dataset <- list(
  "X" = simData[[1]]$X,
  "t" = simData[[1]]$time,
  "di" = simData[[1]]$status
)

# Initial value: null model without covariates
initial <- list("gamma.ini" = rep(0, ncol(dataset$X)))
# Hyperparameters
hyperparPooled <- list(
  "c0"     = 2, # prior of baseline hazard
  "tau"    = 0.0375, # sd for coefficient prior
  "cb"     = 20, # sd for coefficient prior
  "pi.ga"  = 0.02, # prior variable selection probability for standard Cox models
  "a"      = -4, # hyperparameter in MRF prior
  "b"      = 0.1, # hyperparameter in MRF prior
  "G"      = simData$G # hyperparameter in MRF prior
)

\donttest{
# run Bayesian Cox with graph-structured priors
fit <- BayesSurvive(
  survObj = dataset, hyperpar = hyperparPooled,
  initial = initial, nIter = 50
)
# predict survival probabilities of the train data
predict(fit, survObj.new = dataset)
}

}
